/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.macros;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.QueryStringMapper;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.errors.BadRequestError;
import com.intercom.api.resources.unstable.errors.ForbiddenError;
import com.intercom.api.resources.unstable.errors.NotFoundError;
import com.intercom.api.resources.unstable.errors.UnauthorizedError;
import com.intercom.api.resources.unstable.macros.requests.GetMacroRequest;
import com.intercom.api.resources.unstable.macros.requests.ListMacrosRequest;
import com.intercom.api.resources.unstable.macros.types.Macro;
import com.intercom.api.resources.unstable.macros.types.MacroList;
import com.intercom.api.resources.unstable.types.Error;
import java.io.IOException;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawMacrosClient {
    protected final ClientOptions clientOptions;

    public RawMacrosClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * You can fetch a list of all macros (saved replies) in your workspace for use in automating responses.
     * <p>The macros are returned in descending order by updated_at.</p>
     * <p><strong>Pagination</strong></p>
     * <p>This endpoint uses cursor-based pagination via the <code>starting_after</code> parameter. The cursor is a Base64-encoded JSON array containing <code>[updated_at, id]</code> of the last item from the previous page.</p>
     * <p><strong>Placeholder Transformation</strong></p>
     * <p>The API transforms Intercom placeholders to a more standard XML-like format:</p>
     * <ul>
     * <li>From: <code>{{user.name | fallback: 'there'}}</code></li>
     * <li>To: <code>&lt;attribute key=&quot;user.name&quot; default=&quot;there&quot;/&gt;</code></li>
     * </ul>
     */
    public IntercomHttpResponse<MacroList> listMacros() {
        return listMacros(ListMacrosRequest.builder().build());
    }

    /**
     * You can fetch a list of all macros (saved replies) in your workspace for use in automating responses.
     * <p>The macros are returned in descending order by updated_at.</p>
     * <p><strong>Pagination</strong></p>
     * <p>This endpoint uses cursor-based pagination via the <code>starting_after</code> parameter. The cursor is a Base64-encoded JSON array containing <code>[updated_at, id]</code> of the last item from the previous page.</p>
     * <p><strong>Placeholder Transformation</strong></p>
     * <p>The API transforms Intercom placeholders to a more standard XML-like format:</p>
     * <ul>
     * <li>From: <code>{{user.name | fallback: 'there'}}</code></li>
     * <li>To: <code>&lt;attribute key=&quot;user.name&quot; default=&quot;there&quot;/&gt;</code></li>
     * </ul>
     */
    public IntercomHttpResponse<MacroList> listMacros(ListMacrosRequest request) {
        return listMacros(request, null);
    }

    /**
     * You can fetch a list of all macros (saved replies) in your workspace for use in automating responses.
     * <p>The macros are returned in descending order by updated_at.</p>
     * <p><strong>Pagination</strong></p>
     * <p>This endpoint uses cursor-based pagination via the <code>starting_after</code> parameter. The cursor is a Base64-encoded JSON array containing <code>[updated_at, id]</code> of the last item from the previous page.</p>
     * <p><strong>Placeholder Transformation</strong></p>
     * <p>The API transforms Intercom placeholders to a more standard XML-like format:</p>
     * <ul>
     * <li>From: <code>{{user.name | fallback: 'there'}}</code></li>
     * <li>To: <code>&lt;attribute key=&quot;user.name&quot; default=&quot;there&quot;/&gt;</code></li>
     * </ul>
     */
    public IntercomHttpResponse<MacroList> listMacros(ListMacrosRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("macros");
        if (request.getPerPage().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "per_page", request.getPerPage().get(), false);
        }
        if (request.getStartingAfter().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "starting_after", request.getStartingAfter().get(), false);
        }
        if (request.getUpdatedSince().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "updated_since", request.getUpdatedSince().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, MacroList.class), response);
            }
            try {
                switch (response.code()) {
                    case 400:
                        throw new BadRequestError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 403:
                        throw new ForbiddenError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can fetch a single macro (saved reply) by its ID. The macro will only be returned if it is visible to the authenticated user based on its visibility settings.
     * <p><strong>Visibility Rules</strong></p>
     * <p>A macro is returned based on its <code>visible_to</code> setting:</p>
     * <ul>
     * <li><code>everyone</code>: Always visible to all team members</li>
     * <li><code>specific_teams</code>: Only visible if the authenticated user belongs to one of the teams specified in <code>visible_to_team_ids</code></li>
     * </ul>
     * <p>If a macro exists but is not visible to the authenticated user, a 404 error is returned.</p>
     * <p><strong>Placeholder Transformation</strong></p>
     * <p>The API transforms Intercom placeholders to a more standard XML-like format in the <code>body</code> field:</p>
     * <ul>
     * <li>From: <code>{{user.name | fallback: 'there'}}</code></li>
     * <li>To: <code>&lt;attribute key=&quot;user.name&quot; default=&quot;there&quot;/&gt;</code></li>
     * </ul>
     * <p>Default values in placeholders are HTML-escaped for security.</p>
     */
    public IntercomHttpResponse<Optional<Macro>> getMacro(GetMacroRequest request) {
        return getMacro(request, null);
    }

    /**
     * You can fetch a single macro (saved reply) by its ID. The macro will only be returned if it is visible to the authenticated user based on its visibility settings.
     * <p><strong>Visibility Rules</strong></p>
     * <p>A macro is returned based on its <code>visible_to</code> setting:</p>
     * <ul>
     * <li><code>everyone</code>: Always visible to all team members</li>
     * <li><code>specific_teams</code>: Only visible if the authenticated user belongs to one of the teams specified in <code>visible_to_team_ids</code></li>
     * </ul>
     * <p>If a macro exists but is not visible to the authenticated user, a 404 error is returned.</p>
     * <p><strong>Placeholder Transformation</strong></p>
     * <p>The API transforms Intercom placeholders to a more standard XML-like format in the <code>body</code> field:</p>
     * <ul>
     * <li>From: <code>{{user.name | fallback: 'there'}}</code></li>
     * <li>To: <code>&lt;attribute key=&quot;user.name&quot; default=&quot;there&quot;/&gt;</code></li>
     * </ul>
     * <p>Default values in placeholders are HTML-escaped for security.</p>
     */
    public IntercomHttpResponse<Optional<Macro>> getMacro(GetMacroRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("macros")
                .addPathSegment(request.getId())
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(
                                responseBodyString, new TypeReference<Optional<Macro>>() {}),
                        response);
            }
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 403:
                        throw new ForbiddenError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException(
                    "Error with status code " + response.code(), response.code(), errorBody, response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}
