/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.messages;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.QueryStringMapper;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.errors.BadRequestError;
import com.intercom.api.resources.unstable.errors.ForbiddenError;
import com.intercom.api.resources.unstable.errors.InternalServerError;
import com.intercom.api.resources.unstable.errors.UnauthorizedError;
import com.intercom.api.resources.unstable.errors.UnprocessableEntityError;
import com.intercom.api.resources.unstable.messages.requests.GetWhatsAppMessageStatusRequest;
import com.intercom.api.resources.unstable.messages.types.Message;
import com.intercom.api.resources.unstable.types.Error;
import com.intercom.api.resources.unstable.types.WhatsappMessageStatusList;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawMessagesClient {
    protected final ClientOptions clientOptions;

    public AsyncRawMessagesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * You can create a message that has been initiated by an admin. The conversation can be either an in-app message, an email, sms or whatsapp.
     * <blockquote>
     * <p>🚧 Sending for visitors</p>
     * <p>There can be a short delay between when a contact is created and when a contact becomes available to be messaged through the API. A 404 Not Found error will be returned in this case.</p>
     * </blockquote>
     * <p>This will return the Message model that has been created.</p>
     * <blockquote>
     * <p>🚧 Retrieving Associated Conversations</p>
     * <p>As this is a message, there will be no conversation present until the contact responds. Once they do, you will have to search for a contact's conversations with the id of the message.</p>
     * </blockquote>
     */
    public CompletableFuture<IntercomHttpResponse<Message>> createMessage() {
        return createMessage(Optional.empty());
    }

    /**
     * You can create a message that has been initiated by an admin. The conversation can be either an in-app message, an email, sms or whatsapp.
     * <blockquote>
     * <p>🚧 Sending for visitors</p>
     * <p>There can be a short delay between when a contact is created and when a contact becomes available to be messaged through the API. A 404 Not Found error will be returned in this case.</p>
     * </blockquote>
     * <p>This will return the Message model that has been created.</p>
     * <blockquote>
     * <p>🚧 Retrieving Associated Conversations</p>
     * <p>As this is a message, there will be no conversation present until the contact responds. Once they do, you will have to search for a contact's conversations with the id of the message.</p>
     * </blockquote>
     */
    public CompletableFuture<IntercomHttpResponse<Message>> createMessage(Optional<Object> request) {
        return createMessage(request, null);
    }

    /**
     * You can create a message that has been initiated by an admin. The conversation can be either an in-app message, an email, sms or whatsapp.
     * <blockquote>
     * <p>🚧 Sending for visitors</p>
     * <p>There can be a short delay between when a contact is created and when a contact becomes available to be messaged through the API. A 404 Not Found error will be returned in this case.</p>
     * </blockquote>
     * <p>This will return the Message model that has been created.</p>
     * <blockquote>
     * <p>🚧 Retrieving Associated Conversations</p>
     * <p>As this is a message, there will be no conversation present until the contact responds. Once they do, you will have to search for a contact's conversations with the id of the message.</p>
     * </blockquote>
     */
    public CompletableFuture<IntercomHttpResponse<Message>> createMessage(
            Optional<Object> request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("messages")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create("", null);
            if (request.isPresent()) {
                body = RequestBody.create(
                        ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
            }
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<Message>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Message.class), response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 422:
                                future.completeExceptionally(new UnprocessableEntityError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    /**
     * Retrieves statuses of messages sent from the Outbound module. Currently, this API only supports WhatsApp messages.
     * <p>This endpoint returns paginated status events for WhatsApp messages sent via the Outbound module, providing
     * information about delivery state and related message details.</p>
     */
    public CompletableFuture<IntercomHttpResponse<WhatsappMessageStatusList>> getWhatsAppMessageStatus(
            GetWhatsAppMessageStatusRequest request) {
        return getWhatsAppMessageStatus(request, null);
    }

    /**
     * Retrieves statuses of messages sent from the Outbound module. Currently, this API only supports WhatsApp messages.
     * <p>This endpoint returns paginated status events for WhatsApp messages sent via the Outbound module, providing
     * information about delivery state and related message details.</p>
     */
    public CompletableFuture<IntercomHttpResponse<WhatsappMessageStatusList>> getWhatsAppMessageStatus(
            GetWhatsAppMessageStatusRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("messages/status");
        QueryStringMapper.addQueryParameter(httpUrl, "ruleset_id", request.getRulesetId(), false);
        if (request.getPerPage().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "per_page", request.getPerPage().get(), false);
        }
        if (request.getStartingAfter().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "starting_after", request.getStartingAfter().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        CompletableFuture<IntercomHttpResponse<WhatsappMessageStatusList>> future = new CompletableFuture<>();
        client.newCall(okhttpRequest).enqueue(new Callback() {
            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body()) {
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<>(
                                ObjectMappers.JSON_MAPPER.readValue(
                                        responseBodyString, WhatsappMessageStatusList.class),
                                response));
                        return;
                    }
                    try {
                        switch (response.code()) {
                            case 400:
                                future.completeExceptionally(new BadRequestError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                                        response));
                                return;
                            case 401:
                                future.completeExceptionally(new UnauthorizedError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 403:
                                future.completeExceptionally(new ForbiddenError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                            case 500:
                                future.completeExceptionally(new InternalServerError(
                                        ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class),
                                        response));
                                return;
                        }
                    } catch (JsonProcessingException ignored) {
                        // unable to map error response, throwing generic error
                    }
                    Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
                    future.completeExceptionally(new IntercomApiException(
                            "Error with status code " + response.code(), response.code(), errorBody, response));
                    return;
                } catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                }
            }

            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}
