/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.TicketTypeAttributeList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketType.Builder.class)
public final class TicketType {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<Category> category;

    private final Optional<String> name;

    private final Optional<String> description;

    private final Optional<String> icon;

    private final Optional<String> workspaceId;

    private final Optional<TicketTypeAttributeList> ticketTypeAttributes;

    private final Optional<TicketStates> ticketStates;

    private final Optional<Boolean> archived;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Map<String, Object> additionalProperties;

    private TicketType(
            Optional<String> type,
            Optional<String> id,
            Optional<Category> category,
            Optional<String> name,
            Optional<String> description,
            Optional<String> icon,
            Optional<String> workspaceId,
            Optional<TicketTypeAttributeList> ticketTypeAttributes,
            Optional<TicketStates> ticketStates,
            Optional<Boolean> archived,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.category = category;
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.workspaceId = workspaceId;
        this.ticketTypeAttributes = ticketTypeAttributes;
        this.ticketStates = ticketStates;
        this.archived = archived;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>ticket_type</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The id representing the ticket type.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return Category of the Ticket Type.
     */
    @JsonProperty("category")
    public Optional<Category> getCategory() {
        return category;
    }

    /**
     * @return The name of the ticket type
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The description of the ticket type
     */
    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    /**
     * @return The icon of the ticket type
     */
    @JsonProperty("icon")
    public Optional<String> getIcon() {
        return icon;
    }

    /**
     * @return The id of the workspace that the ticket type belongs to.
     */
    @JsonProperty("workspace_id")
    public Optional<String> getWorkspaceId() {
        return workspaceId;
    }

    @JsonProperty("ticket_type_attributes")
    public Optional<TicketTypeAttributeList> getTicketTypeAttributes() {
        return ticketTypeAttributes;
    }

    /**
     * @return A list of ticket states associated with a given ticket type.
     */
    @JsonProperty("ticket_states")
    public Optional<TicketStates> getTicketStates() {
        return ticketStates;
    }

    /**
     * @return Whether the ticket type is archived or not.
     */
    @JsonProperty("archived")
    public Optional<Boolean> getArchived() {
        return archived;
    }

    /**
     * @return The date and time the ticket type was created.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The date and time the ticket type was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketType && equalTo((TicketType) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketType other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && category.equals(other.category)
                && name.equals(other.name)
                && description.equals(other.description)
                && icon.equals(other.icon)
                && workspaceId.equals(other.workspaceId)
                && ticketTypeAttributes.equals(other.ticketTypeAttributes)
                && ticketStates.equals(other.ticketStates)
                && archived.equals(other.archived)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.category,
                this.name,
                this.description,
                this.icon,
                this.workspaceId,
                this.ticketTypeAttributes,
                this.ticketStates,
                this.archived,
                this.createdAt,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<Category> category = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> description = Optional.empty();

        private Optional<String> icon = Optional.empty();

        private Optional<String> workspaceId = Optional.empty();

        private Optional<TicketTypeAttributeList> ticketTypeAttributes = Optional.empty();

        private Optional<TicketStates> ticketStates = Optional.empty();

        private Optional<Boolean> archived = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TicketType other) {
            type(other.getType());
            id(other.getId());
            category(other.getCategory());
            name(other.getName());
            description(other.getDescription());
            icon(other.getIcon());
            workspaceId(other.getWorkspaceId());
            ticketTypeAttributes(other.getTicketTypeAttributes());
            ticketStates(other.getTicketStates());
            archived(other.getArchived());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>ticket_type</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The id representing the ticket type.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>Category of the Ticket Type.</p>
         */
        @JsonSetter(value = "category", nulls = Nulls.SKIP)
        public Builder category(Optional<Category> category) {
            this.category = category;
            return this;
        }

        public Builder category(Category category) {
            this.category = Optional.ofNullable(category);
            return this;
        }

        /**
         * <p>The name of the ticket type</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The description of the ticket type</p>
         */
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * <p>The icon of the ticket type</p>
         */
        @JsonSetter(value = "icon", nulls = Nulls.SKIP)
        public Builder icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        public Builder icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        /**
         * <p>The id of the workspace that the ticket type belongs to.</p>
         */
        @JsonSetter(value = "workspace_id", nulls = Nulls.SKIP)
        public Builder workspaceId(Optional<String> workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = Optional.ofNullable(workspaceId);
            return this;
        }

        @JsonSetter(value = "ticket_type_attributes", nulls = Nulls.SKIP)
        public Builder ticketTypeAttributes(Optional<TicketTypeAttributeList> ticketTypeAttributes) {
            this.ticketTypeAttributes = ticketTypeAttributes;
            return this;
        }

        public Builder ticketTypeAttributes(TicketTypeAttributeList ticketTypeAttributes) {
            this.ticketTypeAttributes = Optional.ofNullable(ticketTypeAttributes);
            return this;
        }

        /**
         * <p>A list of ticket states associated with a given ticket type.</p>
         */
        @JsonSetter(value = "ticket_states", nulls = Nulls.SKIP)
        public Builder ticketStates(Optional<TicketStates> ticketStates) {
            this.ticketStates = ticketStates;
            return this;
        }

        public Builder ticketStates(TicketStates ticketStates) {
            this.ticketStates = Optional.ofNullable(ticketStates);
            return this;
        }

        /**
         * <p>Whether the ticket type is archived or not.</p>
         */
        @JsonSetter(value = "archived", nulls = Nulls.SKIP)
        public Builder archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        public Builder archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        /**
         * <p>The date and time the ticket type was created.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The date and time the ticket type was last updated.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public TicketType build() {
            return new TicketType(
                    type,
                    id,
                    category,
                    name,
                    description,
                    icon,
                    workspaceId,
                    ticketTypeAttributes,
                    ticketStates,
                    archived,
                    createdAt,
                    updatedAt,
                    additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = TicketStates.Builder.class)
    public static final class TicketStates {
        private final Optional<String> type;

        private final Optional<List<Optional<TicketState>>> data;

        private final Map<String, Object> additionalProperties;

        private TicketStates(
                Optional<String> type,
                Optional<List<Optional<TicketState>>> data,
                Map<String, Object> additionalProperties) {
            this.type = type;
            this.data = data;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return String representing the object's type. Always has the value <code>list</code>.
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return A list of ticket states associated with a given ticket type.
         */
        @JsonProperty("data")
        public Optional<List<Optional<TicketState>>> getData() {
            return data;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof TicketStates && equalTo((TicketStates) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(TicketStates other) {
            return type.equals(other.type) && data.equals(other.data);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.data);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<List<Optional<TicketState>>> data = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(TicketStates other) {
                type(other.getType());
                data(other.getData());
                return this;
            }

            /**
             * <p>String representing the object's type. Always has the value <code>list</code>.</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>A list of ticket states associated with a given ticket type.</p>
             */
            @JsonSetter(value = "data", nulls = Nulls.SKIP)
            public Builder data(Optional<List<Optional<TicketState>>> data) {
                this.data = data;
                return this;
            }

            public Builder data(List<Optional<TicketState>> data) {
                this.data = Optional.ofNullable(data);
                return this;
            }

            public TicketStates build() {
                return new TicketStates(type, data, additionalProperties);
            }
        }
    }

    public static final class Category {
        public static final Category BACK_OFFICE = new Category(Value.BACK_OFFICE, "Back-office");

        public static final Category CUSTOMER = new Category(Value.CUSTOMER, "Customer");

        public static final Category TRACKER = new Category(Value.TRACKER, "Tracker");

        private final Value value;

        private final String string;

        Category(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Category && this.string.equals(((Category) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case BACK_OFFICE:
                    return visitor.visitBackOffice();
                case CUSTOMER:
                    return visitor.visitCustomer();
                case TRACKER:
                    return visitor.visitTracker();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Category valueOf(String value) {
            switch (value) {
                case "Back-office":
                    return BACK_OFFICE;
                case "Customer":
                    return CUSTOMER;
                case "Tracker":
                    return TRACKER;
                default:
                    return new Category(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            CUSTOMER,

            BACK_OFFICE,

            TRACKER,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitCustomer();

            T visitBackOffice();

            T visitTracker();

            T visitUnknown(String unknownType);
        }
    }
}
