/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.tickettypes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.tickets.types.TicketType;
import com.intercom.api.resources.unstable.tickettypes.requests.GetTicketTypeRequest;
import com.intercom.api.resources.unstable.types.TicketTypeList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncTicketTypesClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTicketTypesClient rawClient;

    public AsyncTicketTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTicketTypesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTicketTypesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can get a list of all ticket types for a workspace.
     */
    public CompletableFuture<TicketTypeList> listTicketTypes() {
        return this.rawClient.listTicketTypes().thenApply(response -> response.body());
    }

    /**
     * You can get a list of all ticket types for a workspace.
     */
    public CompletableFuture<TicketTypeList> listTicketTypes(RequestOptions requestOptions) {
        return this.rawClient.listTicketTypes(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can create a new ticket type.
     * <blockquote>
     * <p>📘 Creating ticket types.</p>
     * <p>Every ticket type will be created with two default attributes: <em>default_title</em> and <em>default_description</em>.
     * For the <code>icon</code> propery, use an emoji from <a href="https://twemoji-cheatsheet.vercel.app/">Twemoji Cheatsheet</a></p>
     * </blockquote>
     */
    public CompletableFuture<Optional<TicketType>> createTicketType(Object request) {
        return this.rawClient.createTicketType(request).thenApply(response -> response.body());
    }

    /**
     * You can create a new ticket type.
     * <blockquote>
     * <p>📘 Creating ticket types.</p>
     * <p>Every ticket type will be created with two default attributes: <em>default_title</em> and <em>default_description</em>.
     * For the <code>icon</code> propery, use an emoji from <a href="https://twemoji-cheatsheet.vercel.app/">Twemoji Cheatsheet</a></p>
     * </blockquote>
     */
    public CompletableFuture<Optional<TicketType>> createTicketType(Object request, RequestOptions requestOptions) {
        return this.rawClient.createTicketType(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single ticket type.
     */
    public CompletableFuture<Optional<TicketType>> getTicketType(GetTicketTypeRequest request) {
        return this.rawClient.getTicketType(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single ticket type.
     */
    public CompletableFuture<Optional<TicketType>> getTicketType(
            GetTicketTypeRequest request, RequestOptions requestOptions) {
        return this.rawClient.getTicketType(request, requestOptions).thenApply(response -> response.body());
    }
}
