/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AiCallResponse.Builder.class)
public final class AiCallResponse {
    private final Optional<Integer> id;

    private final Optional<Integer> appId;

    private final Optional<String> userPhoneNumber;

    private final Optional<String> status;

    private final Optional<String> intercomCallId;

    private final Optional<String> externalCallId;

    private final Optional<String> intercomConversationId;

    private final Optional<List<Map<String, Object>>> callTranscript;

    private final Optional<String> callSummary;

    private final Optional<List<Map<String, Object>>> intent;

    private final Map<String, Object> additionalProperties;

    private AiCallResponse(
            Optional<Integer> id,
            Optional<Integer> appId,
            Optional<String> userPhoneNumber,
            Optional<String> status,
            Optional<String> intercomCallId,
            Optional<String> externalCallId,
            Optional<String> intercomConversationId,
            Optional<List<Map<String, Object>>> callTranscript,
            Optional<String> callSummary,
            Optional<List<Map<String, Object>>> intent,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.appId = appId;
        this.userPhoneNumber = userPhoneNumber;
        this.status = status;
        this.intercomCallId = intercomCallId;
        this.externalCallId = externalCallId;
        this.intercomConversationId = intercomConversationId;
        this.callTranscript = callTranscript;
        this.callSummary = callSummary;
        this.intent = intent;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the external reference
     */
    @JsonProperty("id")
    public Optional<Integer> getId() {
        return id;
    }

    /**
     * @return The workspace identifier
     */
    @JsonProperty("app_id")
    public Optional<Integer> getAppId() {
        return appId;
    }

    /**
     * @return Phone number in E.164 format for the call
     */
    @JsonProperty("user_phone_number")
    public Optional<String> getUserPhoneNumber() {
        return userPhoneNumber;
    }

    /**
     * @return Status of the call. Can be &quot;registered&quot;, &quot;in-progress&quot;, or a resolution state
     */
    @JsonProperty("status")
    public Optional<String> getStatus() {
        return status;
    }

    /**
     * @return The Intercom call identifier, if the call has been matched
     */
    @JsonProperty("intercom_call_id")
    public Optional<String> getIntercomCallId() {
        return intercomCallId;
    }

    /**
     * @return The external call identifier from the call provider
     */
    @JsonProperty("external_call_id")
    public Optional<String> getExternalCallId() {
        return externalCallId;
    }

    /**
     * @return The Intercom conversation identifier, if a conversation has been created
     */
    @JsonProperty("intercom_conversation_id")
    public Optional<String> getIntercomConversationId() {
        return intercomConversationId;
    }

    /**
     * @return Array of transcript entries for the call
     */
    @JsonProperty("call_transcript")
    public Optional<List<Map<String, Object>>> getCallTranscript() {
        return callTranscript;
    }

    /**
     * @return Summary of the call conversation, truncated to 256 characters. Empty string if no summary available.
     */
    @JsonProperty("call_summary")
    public Optional<String> getCallSummary() {
        return callSummary;
    }

    /**
     * @return Array of intent classifications for the call
     */
    @JsonProperty("intent")
    public Optional<List<Map<String, Object>>> getIntent() {
        return intent;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AiCallResponse && equalTo((AiCallResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AiCallResponse other) {
        return id.equals(other.id)
                && appId.equals(other.appId)
                && userPhoneNumber.equals(other.userPhoneNumber)
                && status.equals(other.status)
                && intercomCallId.equals(other.intercomCallId)
                && externalCallId.equals(other.externalCallId)
                && intercomConversationId.equals(other.intercomConversationId)
                && callTranscript.equals(other.callTranscript)
                && callSummary.equals(other.callSummary)
                && intent.equals(other.intent);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.appId,
                this.userPhoneNumber,
                this.status,
                this.intercomCallId,
                this.externalCallId,
                this.intercomConversationId,
                this.callTranscript,
                this.callSummary,
                this.intent);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Integer> id = Optional.empty();

        private Optional<Integer> appId = Optional.empty();

        private Optional<String> userPhoneNumber = Optional.empty();

        private Optional<String> status = Optional.empty();

        private Optional<String> intercomCallId = Optional.empty();

        private Optional<String> externalCallId = Optional.empty();

        private Optional<String> intercomConversationId = Optional.empty();

        private Optional<List<Map<String, Object>>> callTranscript = Optional.empty();

        private Optional<String> callSummary = Optional.empty();

        private Optional<List<Map<String, Object>>> intent = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(AiCallResponse other) {
            id(other.getId());
            appId(other.getAppId());
            userPhoneNumber(other.getUserPhoneNumber());
            status(other.getStatus());
            intercomCallId(other.getIntercomCallId());
            externalCallId(other.getExternalCallId());
            intercomConversationId(other.getIntercomConversationId());
            callTranscript(other.getCallTranscript());
            callSummary(other.getCallSummary());
            intent(other.getIntent());
            return this;
        }

        /**
         * <p>The unique identifier for the external reference</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<Integer> id) {
            this.id = id;
            return this;
        }

        public Builder id(Integer id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The workspace identifier</p>
         */
        @JsonSetter(value = "app_id", nulls = Nulls.SKIP)
        public Builder appId(Optional<Integer> appId) {
            this.appId = appId;
            return this;
        }

        public Builder appId(Integer appId) {
            this.appId = Optional.ofNullable(appId);
            return this;
        }

        /**
         * <p>Phone number in E.164 format for the call</p>
         */
        @JsonSetter(value = "user_phone_number", nulls = Nulls.SKIP)
        public Builder userPhoneNumber(Optional<String> userPhoneNumber) {
            this.userPhoneNumber = userPhoneNumber;
            return this;
        }

        public Builder userPhoneNumber(String userPhoneNumber) {
            this.userPhoneNumber = Optional.ofNullable(userPhoneNumber);
            return this;
        }

        /**
         * <p>Status of the call. Can be &quot;registered&quot;, &quot;in-progress&quot;, or a resolution state</p>
         */
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public Builder status(Optional<String> status) {
            this.status = status;
            return this;
        }

        public Builder status(String status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        /**
         * <p>The Intercom call identifier, if the call has been matched</p>
         */
        @JsonSetter(value = "intercom_call_id", nulls = Nulls.SKIP)
        public Builder intercomCallId(Optional<String> intercomCallId) {
            this.intercomCallId = intercomCallId;
            return this;
        }

        public Builder intercomCallId(String intercomCallId) {
            this.intercomCallId = Optional.ofNullable(intercomCallId);
            return this;
        }

        /**
         * <p>The external call identifier from the call provider</p>
         */
        @JsonSetter(value = "external_call_id", nulls = Nulls.SKIP)
        public Builder externalCallId(Optional<String> externalCallId) {
            this.externalCallId = externalCallId;
            return this;
        }

        public Builder externalCallId(String externalCallId) {
            this.externalCallId = Optional.ofNullable(externalCallId);
            return this;
        }

        /**
         * <p>The Intercom conversation identifier, if a conversation has been created</p>
         */
        @JsonSetter(value = "intercom_conversation_id", nulls = Nulls.SKIP)
        public Builder intercomConversationId(Optional<String> intercomConversationId) {
            this.intercomConversationId = intercomConversationId;
            return this;
        }

        public Builder intercomConversationId(String intercomConversationId) {
            this.intercomConversationId = Optional.ofNullable(intercomConversationId);
            return this;
        }

        /**
         * <p>Array of transcript entries for the call</p>
         */
        @JsonSetter(value = "call_transcript", nulls = Nulls.SKIP)
        public Builder callTranscript(Optional<List<Map<String, Object>>> callTranscript) {
            this.callTranscript = callTranscript;
            return this;
        }

        public Builder callTranscript(List<Map<String, Object>> callTranscript) {
            this.callTranscript = Optional.ofNullable(callTranscript);
            return this;
        }

        /**
         * <p>Summary of the call conversation, truncated to 256 characters. Empty string if no summary available.</p>
         */
        @JsonSetter(value = "call_summary", nulls = Nulls.SKIP)
        public Builder callSummary(Optional<String> callSummary) {
            this.callSummary = callSummary;
            return this;
        }

        public Builder callSummary(String callSummary) {
            this.callSummary = Optional.ofNullable(callSummary);
            return this;
        }

        /**
         * <p>Array of intent classifications for the call</p>
         */
        @JsonSetter(value = "intent", nulls = Nulls.SKIP)
        public Builder intent(Optional<List<Map<String, Object>>> intent) {
            this.intent = intent;
            return this;
        }

        public Builder intent(List<Map<String, Object>> intent) {
            this.intent = Optional.ofNullable(intent);
            return this;
        }

        public AiCallResponse build() {
            return new AiCallResponse(
                    id,
                    appId,
                    userPhoneNumber,
                    status,
                    intercomCallId,
                    externalCallId,
                    intercomConversationId,
                    callTranscript,
                    callSummary,
                    intent,
                    additionalProperties);
        }
    }
}
