/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationSlaAppliedByRule.Builder.class)
public final class ConversationSlaAppliedByRule {
    private final Optional<String> slaName;

    private final Optional<SlaDefinition> slaDefinition;

    private final Map<String, Object> additionalProperties;

    private ConversationSlaAppliedByRule(
            Optional<String> slaName, Optional<SlaDefinition> slaDefinition, Map<String, Object> additionalProperties) {
        this.slaName = slaName;
        this.slaDefinition = slaDefinition;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Name of the SLA that was applied
     */
    @JsonProperty("sla_name")
    public Optional<String> getSlaName() {
        return slaName;
    }

    /**
     * @return Target times configured for the SLA (in seconds)
     */
    @JsonProperty("sla_definition")
    public Optional<SlaDefinition> getSlaDefinition() {
        return slaDefinition;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationSlaAppliedByRule && equalTo((ConversationSlaAppliedByRule) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationSlaAppliedByRule other) {
        return slaName.equals(other.slaName) && slaDefinition.equals(other.slaDefinition);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.slaName, this.slaDefinition);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> slaName = Optional.empty();

        private Optional<SlaDefinition> slaDefinition = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ConversationSlaAppliedByRule other) {
            slaName(other.getSlaName());
            slaDefinition(other.getSlaDefinition());
            return this;
        }

        /**
         * <p>Name of the SLA that was applied</p>
         */
        @JsonSetter(value = "sla_name", nulls = Nulls.SKIP)
        public Builder slaName(Optional<String> slaName) {
            this.slaName = slaName;
            return this;
        }

        public Builder slaName(String slaName) {
            this.slaName = Optional.ofNullable(slaName);
            return this;
        }

        /**
         * <p>Target times configured for the SLA (in seconds)</p>
         */
        @JsonSetter(value = "sla_definition", nulls = Nulls.SKIP)
        public Builder slaDefinition(Optional<SlaDefinition> slaDefinition) {
            this.slaDefinition = slaDefinition;
            return this;
        }

        public Builder slaDefinition(SlaDefinition slaDefinition) {
            this.slaDefinition = Optional.ofNullable(slaDefinition);
            return this;
        }

        public ConversationSlaAppliedByRule build() {
            return new ConversationSlaAppliedByRule(slaName, slaDefinition, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = SlaDefinition.Builder.class)
    public static final class SlaDefinition {
        private final Optional<Integer> firstReplyTime;

        private final Optional<Integer> nextReplyTime;

        private final Optional<Integer> resolutionTime;

        private final Optional<Integer> timeToClose;

        private final Map<String, Object> additionalProperties;

        private SlaDefinition(
                Optional<Integer> firstReplyTime,
                Optional<Integer> nextReplyTime,
                Optional<Integer> resolutionTime,
                Optional<Integer> timeToClose,
                Map<String, Object> additionalProperties) {
            this.firstReplyTime = firstReplyTime;
            this.nextReplyTime = nextReplyTime;
            this.resolutionTime = resolutionTime;
            this.timeToClose = timeToClose;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return First response time target in seconds
         */
        @JsonProperty("first_reply_time")
        public Optional<Integer> getFirstReplyTime() {
            return firstReplyTime;
        }

        /**
         * @return Next reply time target in seconds
         */
        @JsonProperty("next_reply_time")
        public Optional<Integer> getNextReplyTime() {
            return nextReplyTime;
        }

        /**
         * @return Resolution time target in seconds
         */
        @JsonProperty("resolution_time")
        public Optional<Integer> getResolutionTime() {
            return resolutionTime;
        }

        /**
         * @return Time to close target in seconds
         */
        @JsonProperty("time_to_close")
        public Optional<Integer> getTimeToClose() {
            return timeToClose;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof SlaDefinition && equalTo((SlaDefinition) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(SlaDefinition other) {
            return firstReplyTime.equals(other.firstReplyTime)
                    && nextReplyTime.equals(other.nextReplyTime)
                    && resolutionTime.equals(other.resolutionTime)
                    && timeToClose.equals(other.timeToClose);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.firstReplyTime, this.nextReplyTime, this.resolutionTime, this.timeToClose);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<Integer> firstReplyTime = Optional.empty();

            private Optional<Integer> nextReplyTime = Optional.empty();

            private Optional<Integer> resolutionTime = Optional.empty();

            private Optional<Integer> timeToClose = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(SlaDefinition other) {
                firstReplyTime(other.getFirstReplyTime());
                nextReplyTime(other.getNextReplyTime());
                resolutionTime(other.getResolutionTime());
                timeToClose(other.getTimeToClose());
                return this;
            }

            /**
             * <p>First response time target in seconds</p>
             */
            @JsonSetter(value = "first_reply_time", nulls = Nulls.SKIP)
            public Builder firstReplyTime(Optional<Integer> firstReplyTime) {
                this.firstReplyTime = firstReplyTime;
                return this;
            }

            public Builder firstReplyTime(Integer firstReplyTime) {
                this.firstReplyTime = Optional.ofNullable(firstReplyTime);
                return this;
            }

            /**
             * <p>Next reply time target in seconds</p>
             */
            @JsonSetter(value = "next_reply_time", nulls = Nulls.SKIP)
            public Builder nextReplyTime(Optional<Integer> nextReplyTime) {
                this.nextReplyTime = nextReplyTime;
                return this;
            }

            public Builder nextReplyTime(Integer nextReplyTime) {
                this.nextReplyTime = Optional.ofNullable(nextReplyTime);
                return this;
            }

            /**
             * <p>Resolution time target in seconds</p>
             */
            @JsonSetter(value = "resolution_time", nulls = Nulls.SKIP)
            public Builder resolutionTime(Optional<Integer> resolutionTime) {
                this.resolutionTime = resolutionTime;
                return this;
            }

            public Builder resolutionTime(Integer resolutionTime) {
                this.resolutionTime = Optional.ofNullable(resolutionTime);
                return this;
            }

            /**
             * <p>Time to close target in seconds</p>
             */
            @JsonSetter(value = "time_to_close", nulls = Nulls.SKIP)
            public Builder timeToClose(Optional<Integer> timeToClose) {
                this.timeToClose = timeToClose;
                return this;
            }

            public Builder timeToClose(Integer timeToClose) {
                this.timeToClose = Optional.ofNullable(timeToClose);
                return this;
            }

            public SlaDefinition build() {
                return new SlaDefinition(
                        firstReplyTime, nextReplyTime, resolutionTime, timeToClose, additionalProperties);
            }
        }
    }
}
