/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationTeammates.Builder.class)
public final class ConversationTeammates {
    private final Optional<String> type;

    private final Optional<List<Reference>> teammates;

    private final Map<String, Object> additionalProperties;

    private ConversationTeammates(
            Optional<String> type, Optional<List<Reference>> teammates, Map<String, Object> additionalProperties) {
        this.type = type;
        this.teammates = teammates;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object - <code>admin.list</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The list of teammates who participated in the conversation (wrote at least one conversation part).
     */
    @JsonProperty("teammates")
    public Optional<List<Reference>> getTeammates() {
        return teammates;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationTeammates && equalTo((ConversationTeammates) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationTeammates other) {
        return type.equals(other.type) && teammates.equals(other.teammates);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.teammates);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<List<Reference>> teammates = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ConversationTeammates other) {
            type(other.getType());
            teammates(other.getTeammates());
            return this;
        }

        /**
         * <p>The type of the object - <code>admin.list</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The list of teammates who participated in the conversation (wrote at least one conversation part).</p>
         */
        @JsonSetter(value = "teammates", nulls = Nulls.SKIP)
        public Builder teammates(Optional<List<Reference>> teammates) {
            this.teammates = teammates;
            return this;
        }

        public Builder teammates(List<Reference> teammates) {
            this.teammates = Optional.ofNullable(teammates);
            return this;
        }

        public ConversationTeammates build() {
            return new ConversationTeammates(type, teammates, additionalProperties);
        }
    }
}
