/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateTicketRequestBody.Builder.class)
public final class CreateTicketRequestBody implements ICreateTicketRequestBody {
    private final String ticketTypeId;

    private final List<ContactsItem> contacts;

    private final Optional<String> conversationToLinkId;

    private final Optional<String> companyId;

    private final Optional<Integer> createdAt;

    private final Optional<Assignment> assignment;

    private final Map<String, Object> additionalProperties;

    private CreateTicketRequestBody(
            String ticketTypeId,
            List<ContactsItem> contacts,
            Optional<String> conversationToLinkId,
            Optional<String> companyId,
            Optional<Integer> createdAt,
            Optional<Assignment> assignment,
            Map<String, Object> additionalProperties) {
        this.ticketTypeId = ticketTypeId;
        this.contacts = contacts;
        this.conversationToLinkId = conversationToLinkId;
        this.companyId = companyId;
        this.createdAt = createdAt;
        this.assignment = assignment;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The ID of the type of ticket you want to create
     */
    @JsonProperty("ticket_type_id")
    public String getTicketTypeId() {
        return ticketTypeId;
    }

    /**
     * @return The list of contacts (users or leads) affected by this ticket. Currently only one is allowed
     */
    @JsonProperty("contacts")
    public List<ContactsItem> getContacts() {
        return contacts;
    }

    /**
     * @return The ID of the conversation you want to link to the ticket. Here are the valid ways of linking two tickets:
     * <ul>
     * <li>conversation | back-office ticket</li>
     * <li>customer tickets | non-shared back-office ticket</li>
     * <li>conversation | tracker ticket</li>
     * <li>customer ticket | tracker ticket</li>
     * </ul>
     */
    @JsonProperty("conversation_to_link_id")
    public Optional<String> getConversationToLinkId() {
        return conversationToLinkId;
    }

    /**
     * @return The ID of the company that the ticket is associated with. The unique identifier for the company which is given by Intercom
     */
    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    /**
     * @return The time the ticket was created. If not provided, the current time will be used.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("assignment")
    public Optional<Assignment> getAssignment() {
        return assignment;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateTicketRequestBody && equalTo((CreateTicketRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateTicketRequestBody other) {
        return ticketTypeId.equals(other.ticketTypeId)
                && contacts.equals(other.contacts)
                && conversationToLinkId.equals(other.conversationToLinkId)
                && companyId.equals(other.companyId)
                && createdAt.equals(other.createdAt)
                && assignment.equals(other.assignment);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.ticketTypeId,
                this.contacts,
                this.conversationToLinkId,
                this.companyId,
                this.createdAt,
                this.assignment);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketTypeIdStage builder() {
        return new Builder();
    }

    public interface TicketTypeIdStage {
        /**
         * <p>The ID of the type of ticket you want to create</p>
         */
        _FinalStage ticketTypeId(@NotNull String ticketTypeId);

        Builder from(CreateTicketRequestBody other);
    }

    public interface _FinalStage {
        CreateTicketRequestBody build();

        /**
         * <p>The list of contacts (users or leads) affected by this ticket. Currently only one is allowed</p>
         */
        _FinalStage contacts(List<ContactsItem> contacts);

        _FinalStage addContacts(ContactsItem contacts);

        _FinalStage addAllContacts(List<ContactsItem> contacts);

        /**
         * <p>The ID of the conversation you want to link to the ticket. Here are the valid ways of linking two tickets:</p>
         * <ul>
         * <li>conversation | back-office ticket</li>
         * <li>customer tickets | non-shared back-office ticket</li>
         * <li>conversation | tracker ticket</li>
         * <li>customer ticket | tracker ticket</li>
         * </ul>
         */
        _FinalStage conversationToLinkId(Optional<String> conversationToLinkId);

        _FinalStage conversationToLinkId(String conversationToLinkId);

        /**
         * <p>The ID of the company that the ticket is associated with. The unique identifier for the company which is given by Intercom</p>
         */
        _FinalStage companyId(Optional<String> companyId);

        _FinalStage companyId(String companyId);

        /**
         * <p>The time the ticket was created. If not provided, the current time will be used.</p>
         */
        _FinalStage createdAt(Optional<Integer> createdAt);

        _FinalStage createdAt(Integer createdAt);

        _FinalStage assignment(Optional<Assignment> assignment);

        _FinalStage assignment(Assignment assignment);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TicketTypeIdStage, _FinalStage {
        private String ticketTypeId;

        private Optional<Assignment> assignment = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        private Optional<String> conversationToLinkId = Optional.empty();

        private List<ContactsItem> contacts = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateTicketRequestBody other) {
            ticketTypeId(other.getTicketTypeId());
            contacts(other.getContacts());
            conversationToLinkId(other.getConversationToLinkId());
            companyId(other.getCompanyId());
            createdAt(other.getCreatedAt());
            assignment(other.getAssignment());
            return this;
        }

        /**
         * <p>The ID of the type of ticket you want to create</p>
         * <p>The ID of the type of ticket you want to create</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ticket_type_id")
        public _FinalStage ticketTypeId(@NotNull String ticketTypeId) {
            this.ticketTypeId = Objects.requireNonNull(ticketTypeId, "ticketTypeId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage assignment(Assignment assignment) {
            this.assignment = Optional.ofNullable(assignment);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "assignment", nulls = Nulls.SKIP)
        public _FinalStage assignment(Optional<Assignment> assignment) {
            this.assignment = assignment;
            return this;
        }

        /**
         * <p>The time the ticket was created. If not provided, the current time will be used.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time the ticket was created. If not provided, the current time will be used.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>The ID of the company that the ticket is associated with. The unique identifier for the company which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        /**
         * <p>The ID of the company that the ticket is associated with. The unique identifier for the company which is given by Intercom</p>
         */
        @java.lang.Override
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        /**
         * <p>The ID of the conversation you want to link to the ticket. Here are the valid ways of linking two tickets:</p>
         * <ul>
         * <li>conversation | back-office ticket</li>
         * <li>customer tickets | non-shared back-office ticket</li>
         * <li>conversation | tracker ticket</li>
         * <li>customer ticket | tracker ticket</li>
         * </ul>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage conversationToLinkId(String conversationToLinkId) {
            this.conversationToLinkId = Optional.ofNullable(conversationToLinkId);
            return this;
        }

        /**
         * <p>The ID of the conversation you want to link to the ticket. Here are the valid ways of linking two tickets:</p>
         * <ul>
         * <li>conversation | back-office ticket</li>
         * <li>customer tickets | non-shared back-office ticket</li>
         * <li>conversation | tracker ticket</li>
         * <li>customer ticket | tracker ticket</li>
         * </ul>
         */
        @java.lang.Override
        @JsonSetter(value = "conversation_to_link_id", nulls = Nulls.SKIP)
        public _FinalStage conversationToLinkId(Optional<String> conversationToLinkId) {
            this.conversationToLinkId = conversationToLinkId;
            return this;
        }

        /**
         * <p>The list of contacts (users or leads) affected by this ticket. Currently only one is allowed</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllContacts(List<ContactsItem> contacts) {
            if (contacts != null) {
                this.contacts.addAll(contacts);
            }
            return this;
        }

        /**
         * <p>The list of contacts (users or leads) affected by this ticket. Currently only one is allowed</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addContacts(ContactsItem contacts) {
            this.contacts.add(contacts);
            return this;
        }

        /**
         * <p>The list of contacts (users or leads) affected by this ticket. Currently only one is allowed</p>
         */
        @java.lang.Override
        @JsonSetter(value = "contacts", nulls = Nulls.SKIP)
        public _FinalStage contacts(List<ContactsItem> contacts) {
            this.contacts.clear();
            if (contacts != null) {
                this.contacts.addAll(contacts);
            }
            return this;
        }

        @java.lang.Override
        public CreateTicketRequestBody build() {
            return new CreateTicketRequestBody(
                    ticketTypeId,
                    contacts,
                    conversationToLinkId,
                    companyId,
                    createdAt,
                    assignment,
                    additionalProperties);
        }
    }

    @JsonDeserialize(using = ContactsItem.Deserializer.class)
    public static final class ContactsItem {
        private final Object value;

        private final int type;

        private ContactsItem(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        @SuppressWarnings("unchecked")
        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((Id) this.value);
            } else if (this.type == 1) {
                return visitor.visit((ExternalId) this.value);
            } else if (this.type == 2) {
                return visitor.visit((Email) this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof ContactsItem && equalTo((ContactsItem) other);
        }

        private boolean equalTo(ContactsItem other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return this.value.toString();
        }

        public static ContactsItem of(Id value) {
            return new ContactsItem(value, 0);
        }

        public static ContactsItem of(ExternalId value) {
            return new ContactsItem(value, 1);
        }

        public static ContactsItem of(Email value) {
            return new ContactsItem(value, 2);
        }

        public interface Visitor<T> {
            T visit(Id value);

            T visit(ExternalId value);

            T visit(Email value);
        }

        static final class Deserializer extends StdDeserializer<ContactsItem> {
            Deserializer() {
                super(ContactsItem.class);
            }

            @java.lang.Override
            public ContactsItem deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, Id.class));
                } catch (RuntimeException e) {
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, ExternalId.class));
                } catch (RuntimeException e) {
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, Email.class));
                } catch (RuntimeException e) {
                }
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = Id.Builder.class)
        public static final class Id {
            private final String id;

            private final Map<String, Object> additionalProperties;

            private Id(String id, Map<String, Object> additionalProperties) {
                this.id = id;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return The identifier for the contact as given by Intercom.
             */
            @JsonProperty("id")
            public String getId() {
                return id;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof Id && equalTo((Id) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(Id other) {
                return id.equals(other.id);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.id);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IdStage builder() {
                return new Builder();
            }

            public interface IdStage {
                /**
                 * <p>The identifier for the contact as given by Intercom.</p>
                 */
                _FinalStage id(@NotNull String id);

                Builder from(Id other);
            }

            public interface _FinalStage {
                Id build();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements IdStage, _FinalStage {
                private String id;

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(Id other) {
                    id(other.getId());
                    return this;
                }

                /**
                 * <p>The identifier for the contact as given by Intercom.</p>
                 * <p>The identifier for the contact as given by Intercom.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("id")
                public _FinalStage id(@NotNull String id) {
                    this.id = Objects.requireNonNull(id, "id must not be null");
                    return this;
                }

                @java.lang.Override
                public Id build() {
                    return new Id(id, additionalProperties);
                }
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = ExternalId.Builder.class)
        public static final class ExternalId {
            private final String externalId;

            private final Map<String, Object> additionalProperties;

            private ExternalId(String externalId, Map<String, Object> additionalProperties) {
                this.externalId = externalId;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return The external_id you have defined for the contact who is being added as a participant.
             */
            @JsonProperty("external_id")
            public String getExternalId() {
                return externalId;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof ExternalId && equalTo((ExternalId) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(ExternalId other) {
                return externalId.equals(other.externalId);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.externalId);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static ExternalIdStage builder() {
                return new Builder();
            }

            public interface ExternalIdStage {
                /**
                 * <p>The external_id you have defined for the contact who is being added as a participant.</p>
                 */
                _FinalStage externalId(@NotNull String externalId);

                Builder from(ExternalId other);
            }

            public interface _FinalStage {
                ExternalId build();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements ExternalIdStage, _FinalStage {
                private String externalId;

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(ExternalId other) {
                    externalId(other.getExternalId());
                    return this;
                }

                /**
                 * <p>The external_id you have defined for the contact who is being added as a participant.</p>
                 * <p>The external_id you have defined for the contact who is being added as a participant.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("external_id")
                public _FinalStage externalId(@NotNull String externalId) {
                    this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
                    return this;
                }

                @java.lang.Override
                public ExternalId build() {
                    return new ExternalId(externalId, additionalProperties);
                }
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = Email.Builder.class)
        public static final class Email {
            private final String email;

            private final Map<String, Object> additionalProperties;

            private Email(String email, Map<String, Object> additionalProperties) {
                this.email = email;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return The email you have defined for the contact who is being added as a participant. If a contact with this email does not exist, one will be created.
             */
            @JsonProperty("email")
            public String getEmail() {
                return email;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof Email && equalTo((Email) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(Email other) {
                return email.equals(other.email);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.email);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static EmailStage builder() {
                return new Builder();
            }

            public interface EmailStage {
                /**
                 * <p>The email you have defined for the contact who is being added as a participant. If a contact with this email does not exist, one will be created.</p>
                 */
                _FinalStage email(@NotNull String email);

                Builder from(Email other);
            }

            public interface _FinalStage {
                Email build();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements EmailStage, _FinalStage {
                private String email;

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(Email other) {
                    email(other.getEmail());
                    return this;
                }

                /**
                 * <p>The email you have defined for the contact who is being added as a participant. If a contact with this email does not exist, one will be created.</p>
                 * <p>The email you have defined for the contact who is being added as a participant. If a contact with this email does not exist, one will be created.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("email")
                public _FinalStage email(@NotNull String email) {
                    this.email = Objects.requireNonNull(email, "email must not be null");
                    return this;
                }

                @java.lang.Override
                public Email build() {
                    return new Email(email, additionalProperties);
                }
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Assignment.Builder.class)
    public static final class Assignment {
        private final Optional<String> adminAssigneeId;

        private final Optional<String> teamAssigneeId;

        private final Map<String, Object> additionalProperties;

        private Assignment(
                Optional<String> adminAssigneeId,
                Optional<String> teamAssigneeId,
                Map<String, Object> additionalProperties) {
            this.adminAssigneeId = adminAssigneeId;
            this.teamAssigneeId = teamAssigneeId;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The ID of the admin to which the ticket is assigned. If not provided, the ticket will be unassigned.
         */
        @JsonProperty("admin_assignee_id")
        public Optional<String> getAdminAssigneeId() {
            return adminAssigneeId;
        }

        /**
         * @return The ID of the team to which the ticket is assigned. If not provided, the ticket will be unassigned.
         */
        @JsonProperty("team_assignee_id")
        public Optional<String> getTeamAssigneeId() {
            return teamAssigneeId;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Assignment && equalTo((Assignment) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Assignment other) {
            return adminAssigneeId.equals(other.adminAssigneeId) && teamAssigneeId.equals(other.teamAssigneeId);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.adminAssigneeId, this.teamAssigneeId);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> adminAssigneeId = Optional.empty();

            private Optional<String> teamAssigneeId = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Assignment other) {
                adminAssigneeId(other.getAdminAssigneeId());
                teamAssigneeId(other.getTeamAssigneeId());
                return this;
            }

            /**
             * <p>The ID of the admin to which the ticket is assigned. If not provided, the ticket will be unassigned.</p>
             */
            @JsonSetter(value = "admin_assignee_id", nulls = Nulls.SKIP)
            public Builder adminAssigneeId(Optional<String> adminAssigneeId) {
                this.adminAssigneeId = adminAssigneeId;
                return this;
            }

            public Builder adminAssigneeId(String adminAssigneeId) {
                this.adminAssigneeId = Optional.ofNullable(adminAssigneeId);
                return this;
            }

            /**
             * <p>The ID of the team to which the ticket is assigned. If not provided, the ticket will be unassigned.</p>
             */
            @JsonSetter(value = "team_assignee_id", nulls = Nulls.SKIP)
            public Builder teamAssigneeId(Optional<String> teamAssigneeId) {
                this.teamAssigneeId = teamAssigneeId;
                return this;
            }

            public Builder teamAssigneeId(String teamAssigneeId) {
                this.teamAssigneeId = Optional.ofNullable(teamAssigneeId);
                return this;
            }

            public Assignment build() {
                return new Assignment(adminAssigneeId, teamAssigneeId, additionalProperties);
            }
        }
    }
}
