/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = HandlingEventList.Builder.class)
public final class HandlingEventList {
    private final Optional<List<HandlingEvent>> handlingEvents;

    private final Map<String, Object> additionalProperties;

    private HandlingEventList(Optional<List<HandlingEvent>> handlingEvents, Map<String, Object> additionalProperties) {
        this.handlingEvents = handlingEvents;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Array of handling events
     */
    @JsonProperty("handling_events")
    public Optional<List<HandlingEvent>> getHandlingEvents() {
        return handlingEvents;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof HandlingEventList && equalTo((HandlingEventList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(HandlingEventList other) {
        return handlingEvents.equals(other.handlingEvents);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.handlingEvents);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<HandlingEvent>> handlingEvents = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(HandlingEventList other) {
            handlingEvents(other.getHandlingEvents());
            return this;
        }

        /**
         * <p>Array of handling events</p>
         */
        @JsonSetter(value = "handling_events", nulls = Nulls.SKIP)
        public Builder handlingEvents(Optional<List<HandlingEvent>> handlingEvents) {
            this.handlingEvents = handlingEvents;
            return this;
        }

        public Builder handlingEvents(List<HandlingEvent> handlingEvents) {
            this.handlingEvents = Optional.ofNullable(handlingEvents);
            return this;
        }

        public HandlingEventList build() {
            return new HandlingEventList(handlingEvents, additionalProperties);
        }
    }
}
