/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PriorityChanged.Builder.class)
public final class PriorityChanged {
    private final Optional<CurrentPriority> currentPriority;

    private final Optional<PreviousPriority> previousPriority;

    private final Map<String, Object> additionalProperties;

    private PriorityChanged(
            Optional<CurrentPriority> currentPriority,
            Optional<PreviousPriority> previousPriority,
            Map<String, Object> additionalProperties) {
        this.currentPriority = currentPriority;
        this.previousPriority = previousPriority;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Current priority state
     */
    @JsonProperty("current_priority")
    public Optional<CurrentPriority> getCurrentPriority() {
        return currentPriority;
    }

    /**
     * @return Previous priority state
     */
    @JsonProperty("previous_priority")
    public Optional<PreviousPriority> getPreviousPriority() {
        return previousPriority;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PriorityChanged && equalTo((PriorityChanged) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PriorityChanged other) {
        return currentPriority.equals(other.currentPriority) && previousPriority.equals(other.previousPriority);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.currentPriority, this.previousPriority);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<CurrentPriority> currentPriority = Optional.empty();

        private Optional<PreviousPriority> previousPriority = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(PriorityChanged other) {
            currentPriority(other.getCurrentPriority());
            previousPriority(other.getPreviousPriority());
            return this;
        }

        /**
         * <p>Current priority state</p>
         */
        @JsonSetter(value = "current_priority", nulls = Nulls.SKIP)
        public Builder currentPriority(Optional<CurrentPriority> currentPriority) {
            this.currentPriority = currentPriority;
            return this;
        }

        public Builder currentPriority(CurrentPriority currentPriority) {
            this.currentPriority = Optional.ofNullable(currentPriority);
            return this;
        }

        /**
         * <p>Previous priority state</p>
         */
        @JsonSetter(value = "previous_priority", nulls = Nulls.SKIP)
        public Builder previousPriority(Optional<PreviousPriority> previousPriority) {
            this.previousPriority = previousPriority;
            return this;
        }

        public Builder previousPriority(PreviousPriority previousPriority) {
            this.previousPriority = Optional.ofNullable(previousPriority);
            return this;
        }

        public PriorityChanged build() {
            return new PriorityChanged(currentPriority, previousPriority, additionalProperties);
        }
    }

    public static final class PreviousPriority {
        public static final PreviousPriority PRIORITY = new PreviousPriority(Value.PRIORITY, "priority");

        public static final PreviousPriority NOT_PRIORITY = new PreviousPriority(Value.NOT_PRIORITY, "not_priority");

        private final Value value;

        private final String string;

        PreviousPriority(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof PreviousPriority && this.string.equals(((PreviousPriority) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case PRIORITY:
                    return visitor.visitPriority();
                case NOT_PRIORITY:
                    return visitor.visitNotPriority();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static PreviousPriority valueOf(String value) {
            switch (value) {
                case "priority":
                    return PRIORITY;
                case "not_priority":
                    return NOT_PRIORITY;
                default:
                    return new PreviousPriority(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            PRIORITY,

            NOT_PRIORITY,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitPriority();

            T visitNotPriority();

            T visitUnknown(String unknownType);
        }
    }

    public static final class CurrentPriority {
        public static final CurrentPriority PRIORITY = new CurrentPriority(Value.PRIORITY, "priority");

        public static final CurrentPriority NOT_PRIORITY = new CurrentPriority(Value.NOT_PRIORITY, "not_priority");

        private final Value value;

        private final String string;

        CurrentPriority(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof CurrentPriority && this.string.equals(((CurrentPriority) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case PRIORITY:
                    return visitor.visitPriority();
                case NOT_PRIORITY:
                    return visitor.visitNotPriority();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static CurrentPriority valueOf(String value) {
            switch (value) {
                case "priority":
                    return PRIORITY;
                case "not_priority":
                    return NOT_PRIORITY;
                default:
                    return new CurrentPriority(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            PRIORITY,

            NOT_PRIORITY,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitPriority();

            T visitNotPriority();

            T visitUnknown(String unknownType);
        }
    }
}
