/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = QuickReplyOption.Builder.class)
public final class QuickReplyOption implements IQuickReplyOption {
    private final String text;

    private final String uuid;

    private final Map<String, Object> additionalProperties;

    private QuickReplyOption(String text, String uuid, Map<String, Object> additionalProperties) {
        this.text = text;
        this.uuid = uuid;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The text to display in this quick reply option.
     */
    @JsonProperty("text")
    public String getText() {
        return text;
    }

    /**
     * @return A unique identifier for this quick reply option. This value will be available within the metadata of the comment conversation part that is created when a user clicks on this reply option.
     */
    @JsonProperty("uuid")
    public String getUuid() {
        return uuid;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof QuickReplyOption && equalTo((QuickReplyOption) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(QuickReplyOption other) {
        return text.equals(other.text) && uuid.equals(other.uuid);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.text, this.uuid);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    public interface TextStage {
        /**
         * <p>The text to display in this quick reply option.</p>
         */
        UuidStage text(@NotNull String text);

        Builder from(QuickReplyOption other);
    }

    public interface UuidStage {
        /**
         * <p>A unique identifier for this quick reply option. This value will be available within the metadata of the comment conversation part that is created when a user clicks on this reply option.</p>
         */
        _FinalStage uuid(@NotNull String uuid);
    }

    public interface _FinalStage {
        QuickReplyOption build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TextStage, UuidStage, _FinalStage {
        private String text;

        private String uuid;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(QuickReplyOption other) {
            text(other.getText());
            uuid(other.getUuid());
            return this;
        }

        /**
         * <p>The text to display in this quick reply option.</p>
         * <p>The text to display in this quick reply option.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("text")
        public UuidStage text(@NotNull String text) {
            this.text = Objects.requireNonNull(text, "text must not be null");
            return this;
        }

        /**
         * <p>A unique identifier for this quick reply option. This value will be available within the metadata of the comment conversation part that is created when a user clicks on this reply option.</p>
         * <p>A unique identifier for this quick reply option. This value will be available within the metadata of the comment conversation part that is created when a user clicks on this reply option.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("uuid")
        public _FinalStage uuid(@NotNull String uuid) {
            this.uuid = Objects.requireNonNull(uuid, "uuid must not be null");
            return this;
        }

        @java.lang.Override
        public QuickReplyOption build() {
            return new QuickReplyOption(text, uuid, additionalProperties);
        }
    }
}
