/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Recipient.Builder.class)
public final class Recipient {
    private final Type type;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private Recipient(Type type, String id, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The role associated to the contact - <code>user</code> or <code>lead</code>.
     */
    @JsonProperty("type")
    public Type getType() {
        return type;
    }

    /**
     * @return The identifier for the contact which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Recipient && equalTo((Recipient) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Recipient other) {
        return type.equals(other.type) && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * <p>The role associated to the contact - <code>user</code> or <code>lead</code>.</p>
         */
        IdStage type(@NotNull Type type);

        Builder from(Recipient other);
    }

    public interface IdStage {
        /**
         * <p>The identifier for the contact which is given by Intercom.</p>
         */
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        Recipient build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, IdStage, _FinalStage {
        private Type type;

        private String id;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Recipient other) {
            type(other.getType());
            id(other.getId());
            return this;
        }

        /**
         * <p>The role associated to the contact - <code>user</code> or <code>lead</code>.</p>
         * <p>The role associated to the contact - <code>user</code> or <code>lead</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public IdStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>The identifier for the contact which is given by Intercom.</p>
         * <p>The identifier for the contact which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public Recipient build() {
            return new Recipient(type, id, additionalProperties);
        }
    }

    public static final class Type {
        public static final Type USER = new Type(Value.USER, "user");

        public static final Type LEAD = new Type(Value.LEAD, "lead");

        private final Value value;

        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case USER:
                    return visitor.visitUser();
                case LEAD:
                    return visitor.visitLead();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "user":
                    return USER;
                case "lead":
                    return LEAD;
                default:
                    return new Type(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            USER,

            LEAD,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitUser();

            T visitLead();

            T visitUnknown(String unknownType);
        }
    }
}
