/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Snoozed.Builder.class)
public final class Snoozed {
    private final Optional<String> until;

    private final Optional<OffsetDateTime> customUntilTime;

    private final Map<String, Object> additionalProperties;

    private Snoozed(
            Optional<String> until,
            Optional<OffsetDateTime> customUntilTime,
            Map<String, Object> additionalProperties) {
        this.until = until;
        this.customUntilTime = customUntilTime;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Human-readable description of snooze duration
     */
    @JsonProperty("until")
    public Optional<String> getUntil() {
        return until;
    }

    /**
     * @return ISO timestamp for custom snooze times (null for general snoozes)
     */
    @JsonProperty("custom_until_time")
    public Optional<OffsetDateTime> getCustomUntilTime() {
        return customUntilTime;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Snoozed && equalTo((Snoozed) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Snoozed other) {
        return until.equals(other.until) && customUntilTime.equals(other.customUntilTime);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.until, this.customUntilTime);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> until = Optional.empty();

        private Optional<OffsetDateTime> customUntilTime = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(Snoozed other) {
            until(other.getUntil());
            customUntilTime(other.getCustomUntilTime());
            return this;
        }

        /**
         * <p>Human-readable description of snooze duration</p>
         */
        @JsonSetter(value = "until", nulls = Nulls.SKIP)
        public Builder until(Optional<String> until) {
            this.until = until;
            return this;
        }

        public Builder until(String until) {
            this.until = Optional.ofNullable(until);
            return this;
        }

        /**
         * <p>ISO timestamp for custom snooze times (null for general snoozes)</p>
         */
        @JsonSetter(value = "custom_until_time", nulls = Nulls.SKIP)
        public Builder customUntilTime(Optional<OffsetDateTime> customUntilTime) {
            this.customUntilTime = customUntilTime;
            return this;
        }

        public Builder customUntilTime(OffsetDateTime customUntilTime) {
            this.customUntilTime = Optional.ofNullable(customUntilTime);
            return this;
        }

        public Snoozed build() {
            return new Snoozed(until, customUntilTime, additionalProperties);
        }
    }
}
