/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TeammateReference.Builder.class)
public final class TeammateReference {
    private final Type type;

    private final int id;

    private final String name;

    private final Optional<String> email;

    private final Map<String, Object> additionalProperties;

    private TeammateReference(
            Type type, int id, String name, Optional<String> email, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.email = email;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of teammate
     */
    @JsonProperty("type")
    public Type getType() {
        return type;
    }

    /**
     * @return The unique identifier of the teammate
     */
    @JsonProperty("id")
    public int getId() {
        return id;
    }

    /**
     * @return The display name of the teammate
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The email address of the teammate (optional for teams/bots)
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TeammateReference && equalTo((TeammateReference) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TeammateReference other) {
        return type.equals(other.type) && id == other.id && name.equals(other.name) && email.equals(other.email);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.id, this.name, this.email);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * <p>The type of teammate</p>
         */
        IdStage type(@NotNull Type type);

        Builder from(TeammateReference other);
    }

    public interface IdStage {
        /**
         * <p>The unique identifier of the teammate</p>
         */
        NameStage id(int id);
    }

    public interface NameStage {
        /**
         * <p>The display name of the teammate</p>
         */
        _FinalStage name(@NotNull String name);
    }

    public interface _FinalStage {
        TeammateReference build();

        /**
         * <p>The email address of the teammate (optional for teams/bots)</p>
         */
        _FinalStage email(Optional<String> email);

        _FinalStage email(String email);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, IdStage, NameStage, _FinalStage {
        private Type type;

        private int id;

        private String name;

        private Optional<String> email = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TeammateReference other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            email(other.getEmail());
            return this;
        }

        /**
         * <p>The type of teammate</p>
         * <p>The type of teammate</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public IdStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>The unique identifier of the teammate</p>
         * <p>The unique identifier of the teammate</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(int id) {
            this.id = id;
            return this;
        }

        /**
         * <p>The display name of the teammate</p>
         * <p>The display name of the teammate</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * <p>The email address of the teammate (optional for teams/bots)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>The email address of the teammate (optional for teams/bots)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        @java.lang.Override
        public TeammateReference build() {
            return new TeammateReference(type, id, name, email, additionalProperties);
        }
    }

    public static final class Type {
        public static final Type BOT = new Type(Value.BOT, "bot");

        public static final Type ADMIN = new Type(Value.ADMIN, "admin");

        public static final Type TEAM = new Type(Value.TEAM, "team");

        private final Value value;

        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case BOT:
                    return visitor.visitBot();
                case ADMIN:
                    return visitor.visitAdmin();
                case TEAM:
                    return visitor.visitTeam();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "bot":
                    return BOT;
                case "admin":
                    return ADMIN;
                case "team":
                    return TEAM;
                default:
                    return new Type(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            ADMIN,

            TEAM,

            BOT,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitAdmin();

            T visitTeam();

            T visitBot();

            T visitUnknown(String unknownType);
        }
    }
}
