/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = VisitorDeletedObject.Builder.class)
public final class VisitorDeletedObject {
    private final Optional<String> id;

    private final Optional<String> type;

    private final Optional<String> userId;

    private final Map<String, Object> additionalProperties;

    private VisitorDeletedObject(
            Optional<String> id,
            Optional<String> type,
            Optional<String> userId,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.type = type;
        this.userId = userId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the visitor which is given by Intercom.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The type of object which was deleted
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return Automatically generated identifier for the Visitor.
     */
    @JsonProperty("user_id")
    public Optional<String> getUserId() {
        return userId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof VisitorDeletedObject && equalTo((VisitorDeletedObject) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(VisitorDeletedObject other) {
        return id.equals(other.id) && type.equals(other.type) && userId.equals(other.userId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.type, this.userId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();

        private Optional<String> type = Optional.empty();

        private Optional<String> userId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(VisitorDeletedObject other) {
            id(other.getId());
            type(other.getType());
            userId(other.getUserId());
            return this;
        }

        /**
         * <p>The unique identifier for the visitor which is given by Intercom.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The type of object which was deleted</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>Automatically generated identifier for the Visitor.</p>
         */
        @JsonSetter(value = "user_id", nulls = Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        public VisitorDeletedObject build() {
            return new VisitorDeletedObject(id, type, userId, additionalProperties);
        }
    }
}
