/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = WorkflowExport.Builder.class)
public final class WorkflowExport {
    private final Optional<String> exportVersion;

    private final Optional<OffsetDateTime> exportedAt;

    private final Optional<Integer> appId;

    private final Optional<Workflow> workflow;

    private final Map<String, Object> additionalProperties;

    private WorkflowExport(
            Optional<String> exportVersion,
            Optional<OffsetDateTime> exportedAt,
            Optional<Integer> appId,
            Optional<Workflow> workflow,
            Map<String, Object> additionalProperties) {
        this.exportVersion = exportVersion;
        this.exportedAt = exportedAt;
        this.appId = appId;
        this.workflow = workflow;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The version of the export format.
     */
    @JsonProperty("export_version")
    public Optional<String> getExportVersion() {
        return exportVersion;
    }

    /**
     * @return The timestamp when the export was generated.
     */
    @JsonProperty("exported_at")
    public Optional<OffsetDateTime> getExportedAt() {
        return exportedAt;
    }

    /**
     * @return The workspace identifier.
     */
    @JsonProperty("app_id")
    public Optional<Integer> getAppId() {
        return appId;
    }

    /**
     * @return The workflow configuration.
     */
    @JsonProperty("workflow")
    public Optional<Workflow> getWorkflow() {
        return workflow;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof WorkflowExport && equalTo((WorkflowExport) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WorkflowExport other) {
        return exportVersion.equals(other.exportVersion)
                && exportedAt.equals(other.exportedAt)
                && appId.equals(other.appId)
                && workflow.equals(other.workflow);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.exportVersion, this.exportedAt, this.appId, this.workflow);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> exportVersion = Optional.empty();

        private Optional<OffsetDateTime> exportedAt = Optional.empty();

        private Optional<Integer> appId = Optional.empty();

        private Optional<Workflow> workflow = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(WorkflowExport other) {
            exportVersion(other.getExportVersion());
            exportedAt(other.getExportedAt());
            appId(other.getAppId());
            workflow(other.getWorkflow());
            return this;
        }

        /**
         * <p>The version of the export format.</p>
         */
        @JsonSetter(value = "export_version", nulls = Nulls.SKIP)
        public Builder exportVersion(Optional<String> exportVersion) {
            this.exportVersion = exportVersion;
            return this;
        }

        public Builder exportVersion(String exportVersion) {
            this.exportVersion = Optional.ofNullable(exportVersion);
            return this;
        }

        /**
         * <p>The timestamp when the export was generated.</p>
         */
        @JsonSetter(value = "exported_at", nulls = Nulls.SKIP)
        public Builder exportedAt(Optional<OffsetDateTime> exportedAt) {
            this.exportedAt = exportedAt;
            return this;
        }

        public Builder exportedAt(OffsetDateTime exportedAt) {
            this.exportedAt = Optional.ofNullable(exportedAt);
            return this;
        }

        /**
         * <p>The workspace identifier.</p>
         */
        @JsonSetter(value = "app_id", nulls = Nulls.SKIP)
        public Builder appId(Optional<Integer> appId) {
            this.appId = appId;
            return this;
        }

        public Builder appId(Integer appId) {
            this.appId = Optional.ofNullable(appId);
            return this;
        }

        /**
         * <p>The workflow configuration.</p>
         */
        @JsonSetter(value = "workflow", nulls = Nulls.SKIP)
        public Builder workflow(Optional<Workflow> workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder workflow(Workflow workflow) {
            this.workflow = Optional.ofNullable(workflow);
            return this;
        }

        public WorkflowExport build() {
            return new WorkflowExport(exportVersion, exportedAt, appId, workflow, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Workflow.Builder.class)
    public static final class Workflow {
        private final Optional<String> id;

        private final Optional<String> title;

        private final Optional<String> description;

        private final Optional<String> triggerType;

        private final Optional<State> state;

        private final Optional<List<String>> targetChannels;

        private final Optional<List<String>> preferredDevices;

        private final Optional<OffsetDateTime> createdAt;

        private final Optional<OffsetDateTime> updatedAt;

        private final Optional<Map<String, Object>> targeting;

        private final Optional<Map<String, Object>> snapshot;

        private final Optional<List<Map<String, Object>>> attributes;

        private final Optional<List<Map<String, Object>>> embeddedRules;

        private final Map<String, Object> additionalProperties;

        private Workflow(
                Optional<String> id,
                Optional<String> title,
                Optional<String> description,
                Optional<String> triggerType,
                Optional<State> state,
                Optional<List<String>> targetChannels,
                Optional<List<String>> preferredDevices,
                Optional<OffsetDateTime> createdAt,
                Optional<OffsetDateTime> updatedAt,
                Optional<Map<String, Object>> targeting,
                Optional<Map<String, Object>> snapshot,
                Optional<List<Map<String, Object>>> attributes,
                Optional<List<Map<String, Object>>> embeddedRules,
                Map<String, Object> additionalProperties) {
            this.id = id;
            this.title = title;
            this.description = description;
            this.triggerType = triggerType;
            this.state = state;
            this.targetChannels = targetChannels;
            this.preferredDevices = preferredDevices;
            this.createdAt = createdAt;
            this.updatedAt = updatedAt;
            this.targeting = targeting;
            this.snapshot = snapshot;
            this.attributes = attributes;
            this.embeddedRules = embeddedRules;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The unique identifier for the workflow.
         */
        @JsonProperty("id")
        public Optional<String> getId() {
            return id;
        }

        /**
         * @return The title of the workflow.
         */
        @JsonProperty("title")
        public Optional<String> getTitle() {
            return title;
        }

        /**
         * @return The description of the workflow.
         */
        @JsonProperty("description")
        public Optional<String> getDescription() {
            return description;
        }

        /**
         * @return The type of trigger that starts this workflow.
         */
        @JsonProperty("trigger_type")
        public Optional<String> getTriggerType() {
            return triggerType;
        }

        /**
         * @return The current state of the workflow.
         */
        @JsonProperty("state")
        public Optional<State> getState() {
            return state;
        }

        /**
         * @return The channels this workflow targets.
         */
        @JsonProperty("target_channels")
        public Optional<List<String>> getTargetChannels() {
            return targetChannels;
        }

        /**
         * @return The preferred devices for this workflow.
         */
        @JsonProperty("preferred_devices")
        public Optional<List<String>> getPreferredDevices() {
            return preferredDevices;
        }

        /**
         * @return When the workflow was created.
         */
        @JsonProperty("created_at")
        public Optional<OffsetDateTime> getCreatedAt() {
            return createdAt;
        }

        /**
         * @return When the workflow was last updated.
         */
        @JsonProperty("updated_at")
        public Optional<OffsetDateTime> getUpdatedAt() {
            return updatedAt;
        }

        /**
         * @return The targeting rules for this workflow.
         */
        @JsonProperty("targeting")
        public Optional<Map<String, Object>> getTargeting() {
            return targeting;
        }

        /**
         * @return The current snapshot of workflow steps and configuration.
         */
        @JsonProperty("snapshot")
        public Optional<Map<String, Object>> getSnapshot() {
            return snapshot;
        }

        /**
         * @return Custom attributes defined for this workflow.
         */
        @JsonProperty("attributes")
        public Optional<List<Map<String, Object>>> getAttributes() {
            return attributes;
        }

        /**
         * @return Rules embedded within the workflow steps.
         */
        @JsonProperty("embedded_rules")
        public Optional<List<Map<String, Object>>> getEmbeddedRules() {
            return embeddedRules;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Workflow && equalTo((Workflow) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Workflow other) {
            return id.equals(other.id)
                    && title.equals(other.title)
                    && description.equals(other.description)
                    && triggerType.equals(other.triggerType)
                    && state.equals(other.state)
                    && targetChannels.equals(other.targetChannels)
                    && preferredDevices.equals(other.preferredDevices)
                    && createdAt.equals(other.createdAt)
                    && updatedAt.equals(other.updatedAt)
                    && targeting.equals(other.targeting)
                    && snapshot.equals(other.snapshot)
                    && attributes.equals(other.attributes)
                    && embeddedRules.equals(other.embeddedRules);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(
                    this.id,
                    this.title,
                    this.description,
                    this.triggerType,
                    this.state,
                    this.targetChannels,
                    this.preferredDevices,
                    this.createdAt,
                    this.updatedAt,
                    this.targeting,
                    this.snapshot,
                    this.attributes,
                    this.embeddedRules);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> id = Optional.empty();

            private Optional<String> title = Optional.empty();

            private Optional<String> description = Optional.empty();

            private Optional<String> triggerType = Optional.empty();

            private Optional<State> state = Optional.empty();

            private Optional<List<String>> targetChannels = Optional.empty();

            private Optional<List<String>> preferredDevices = Optional.empty();

            private Optional<OffsetDateTime> createdAt = Optional.empty();

            private Optional<OffsetDateTime> updatedAt = Optional.empty();

            private Optional<Map<String, Object>> targeting = Optional.empty();

            private Optional<Map<String, Object>> snapshot = Optional.empty();

            private Optional<List<Map<String, Object>>> attributes = Optional.empty();

            private Optional<List<Map<String, Object>>> embeddedRules = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Workflow other) {
                id(other.getId());
                title(other.getTitle());
                description(other.getDescription());
                triggerType(other.getTriggerType());
                state(other.getState());
                targetChannels(other.getTargetChannels());
                preferredDevices(other.getPreferredDevices());
                createdAt(other.getCreatedAt());
                updatedAt(other.getUpdatedAt());
                targeting(other.getTargeting());
                snapshot(other.getSnapshot());
                attributes(other.getAttributes());
                embeddedRules(other.getEmbeddedRules());
                return this;
            }

            /**
             * <p>The unique identifier for the workflow.</p>
             */
            @JsonSetter(value = "id", nulls = Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            /**
             * <p>The title of the workflow.</p>
             */
            @JsonSetter(value = "title", nulls = Nulls.SKIP)
            public Builder title(Optional<String> title) {
                this.title = title;
                return this;
            }

            public Builder title(String title) {
                this.title = Optional.ofNullable(title);
                return this;
            }

            /**
             * <p>The description of the workflow.</p>
             */
            @JsonSetter(value = "description", nulls = Nulls.SKIP)
            public Builder description(Optional<String> description) {
                this.description = description;
                return this;
            }

            public Builder description(String description) {
                this.description = Optional.ofNullable(description);
                return this;
            }

            /**
             * <p>The type of trigger that starts this workflow.</p>
             */
            @JsonSetter(value = "trigger_type", nulls = Nulls.SKIP)
            public Builder triggerType(Optional<String> triggerType) {
                this.triggerType = triggerType;
                return this;
            }

            public Builder triggerType(String triggerType) {
                this.triggerType = Optional.ofNullable(triggerType);
                return this;
            }

            /**
             * <p>The current state of the workflow.</p>
             */
            @JsonSetter(value = "state", nulls = Nulls.SKIP)
            public Builder state(Optional<State> state) {
                this.state = state;
                return this;
            }

            public Builder state(State state) {
                this.state = Optional.ofNullable(state);
                return this;
            }

            /**
             * <p>The channels this workflow targets.</p>
             */
            @JsonSetter(value = "target_channels", nulls = Nulls.SKIP)
            public Builder targetChannels(Optional<List<String>> targetChannels) {
                this.targetChannels = targetChannels;
                return this;
            }

            public Builder targetChannels(List<String> targetChannels) {
                this.targetChannels = Optional.ofNullable(targetChannels);
                return this;
            }

            /**
             * <p>The preferred devices for this workflow.</p>
             */
            @JsonSetter(value = "preferred_devices", nulls = Nulls.SKIP)
            public Builder preferredDevices(Optional<List<String>> preferredDevices) {
                this.preferredDevices = preferredDevices;
                return this;
            }

            public Builder preferredDevices(List<String> preferredDevices) {
                this.preferredDevices = Optional.ofNullable(preferredDevices);
                return this;
            }

            /**
             * <p>When the workflow was created.</p>
             */
            @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
            public Builder createdAt(Optional<OffsetDateTime> createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            public Builder createdAt(OffsetDateTime createdAt) {
                this.createdAt = Optional.ofNullable(createdAt);
                return this;
            }

            /**
             * <p>When the workflow was last updated.</p>
             */
            @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
            public Builder updatedAt(Optional<OffsetDateTime> updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            public Builder updatedAt(OffsetDateTime updatedAt) {
                this.updatedAt = Optional.ofNullable(updatedAt);
                return this;
            }

            /**
             * <p>The targeting rules for this workflow.</p>
             */
            @JsonSetter(value = "targeting", nulls = Nulls.SKIP)
            public Builder targeting(Optional<Map<String, Object>> targeting) {
                this.targeting = targeting;
                return this;
            }

            public Builder targeting(Map<String, Object> targeting) {
                this.targeting = Optional.ofNullable(targeting);
                return this;
            }

            /**
             * <p>The current snapshot of workflow steps and configuration.</p>
             */
            @JsonSetter(value = "snapshot", nulls = Nulls.SKIP)
            public Builder snapshot(Optional<Map<String, Object>> snapshot) {
                this.snapshot = snapshot;
                return this;
            }

            public Builder snapshot(Map<String, Object> snapshot) {
                this.snapshot = Optional.ofNullable(snapshot);
                return this;
            }

            /**
             * <p>Custom attributes defined for this workflow.</p>
             */
            @JsonSetter(value = "attributes", nulls = Nulls.SKIP)
            public Builder attributes(Optional<List<Map<String, Object>>> attributes) {
                this.attributes = attributes;
                return this;
            }

            public Builder attributes(List<Map<String, Object>> attributes) {
                this.attributes = Optional.ofNullable(attributes);
                return this;
            }

            /**
             * <p>Rules embedded within the workflow steps.</p>
             */
            @JsonSetter(value = "embedded_rules", nulls = Nulls.SKIP)
            public Builder embeddedRules(Optional<List<Map<String, Object>>> embeddedRules) {
                this.embeddedRules = embeddedRules;
                return this;
            }

            public Builder embeddedRules(List<Map<String, Object>> embeddedRules) {
                this.embeddedRules = Optional.ofNullable(embeddedRules);
                return this;
            }

            public Workflow build() {
                return new Workflow(
                        id,
                        title,
                        description,
                        triggerType,
                        state,
                        targetChannels,
                        preferredDevices,
                        createdAt,
                        updatedAt,
                        targeting,
                        snapshot,
                        attributes,
                        embeddedRules,
                        additionalProperties);
            }
        }

        public static final class State {
            public static final State LIVE = new State(Value.LIVE, "live");

            public static final State PAUSED = new State(Value.PAUSED, "paused");

            public static final State DRAFT = new State(Value.DRAFT, "draft");

            private final Value value;

            private final String string;

            State(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return value;
            }

            @java.lang.Override
            @JsonValue
            public String toString() {
                return this.string;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                return (this == other) || (other instanceof State && this.string.equals(((State) other).string));
            }

            @java.lang.Override
            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (value) {
                    case LIVE:
                        return visitor.visitLive();
                    case PAUSED:
                        return visitor.visitPaused();
                    case DRAFT:
                        return visitor.visitDraft();
                    case UNKNOWN:
                    default:
                        return visitor.visitUnknown(string);
                }
            }

            @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
            public static State valueOf(String value) {
                switch (value) {
                    case "live":
                        return LIVE;
                    case "paused":
                        return PAUSED;
                    case "draft":
                        return DRAFT;
                    default:
                        return new State(Value.UNKNOWN, value);
                }
            }

            public enum Value {
                LIVE,

                DRAFT,

                PAUSED,

                UNKNOWN
            }

            public interface Visitor<T> {
                T visitLive();

                T visitDraft();

                T visitPaused();

                T visitUnknown(String unknownType);
            }
        }
    }
}
