/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ActivityLogList.Builder.class)
public final class ActivityLogList {
    private final Optional<String> type;

    private final Optional<CursorPages> pages;

    private final Optional<List<Optional<ActivityLog>>> activityLogs;

    private final Map<String, Object> additionalProperties;

    private ActivityLogList(
            Optional<String> type,
            Optional<CursorPages> pages,
            Optional<List<Optional<ActivityLog>>> activityLogs,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.pages = pages;
        this.activityLogs = activityLogs;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>activity_log.list</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    @JsonProperty("pages")
    public Optional<CursorPages> getPages() {
        return pages;
    }

    /**
     * @return An array of activity logs
     */
    @JsonProperty("activity_logs")
    public Optional<List<Optional<ActivityLog>>> getActivityLogs() {
        return activityLogs;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ActivityLogList && equalTo((ActivityLogList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ActivityLogList other) {
        return type.equals(other.type) && pages.equals(other.pages) && activityLogs.equals(other.activityLogs);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.pages, this.activityLogs);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<CursorPages> pages = Optional.empty();

        private Optional<List<Optional<ActivityLog>>> activityLogs = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ActivityLogList other) {
            type(other.getType());
            pages(other.getPages());
            activityLogs(other.getActivityLogs());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>activity_log.list</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        /**
         * <p>An array of activity logs</p>
         */
        @JsonSetter(value = "activity_logs", nulls = Nulls.SKIP)
        public Builder activityLogs(Optional<List<Optional<ActivityLog>>> activityLogs) {
            this.activityLogs = activityLogs;
            return this;
        }

        public Builder activityLogs(List<Optional<ActivityLog>> activityLogs) {
            this.activityLogs = Optional.ofNullable(activityLogs);
            return this;
        }

        public ActivityLogList build() {
            return new ActivityLogList(type, pages, activityLogs, additionalProperties);
        }
    }
}
