/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ActivityLogMetadata.Builder.class)
public final class ActivityLogMetadata {
    private final Optional<String> signInMethod;

    private final Optional<String> externalId;

    private final Optional<Boolean> awayMode;

    private final Optional<String> awayStatusReason;

    private final Optional<Boolean> reassignConversations;

    private final Optional<String> source;

    private final Optional<String> autoChanged;

    private final Optional<Integer> updateBy;

    private final Optional<String> updateByName;

    private final Optional<Integer> conversationAssignmentLimit;

    private final Optional<Integer> ticketAssignmentLimit;

    private final Optional<Team> team;

    private final Optional<Integer> teamAssignmentLimit;

    private final Optional<Boolean> enabled;

    private final Optional<Integer> consentId;

    private final Optional<OffsetDateTime> expiredAt;

    private final Optional<Map<String, Object>> before;

    private final Optional<Map<String, Object>> after;

    private final Map<String, Object> additionalProperties;

    private ActivityLogMetadata(
            Optional<String> signInMethod,
            Optional<String> externalId,
            Optional<Boolean> awayMode,
            Optional<String> awayStatusReason,
            Optional<Boolean> reassignConversations,
            Optional<String> source,
            Optional<String> autoChanged,
            Optional<Integer> updateBy,
            Optional<String> updateByName,
            Optional<Integer> conversationAssignmentLimit,
            Optional<Integer> ticketAssignmentLimit,
            Optional<Team> team,
            Optional<Integer> teamAssignmentLimit,
            Optional<Boolean> enabled,
            Optional<Integer> consentId,
            Optional<OffsetDateTime> expiredAt,
            Optional<Map<String, Object>> before,
            Optional<Map<String, Object>> after,
            Map<String, Object> additionalProperties) {
        this.signInMethod = signInMethod;
        this.externalId = externalId;
        this.awayMode = awayMode;
        this.awayStatusReason = awayStatusReason;
        this.reassignConversations = reassignConversations;
        this.source = source;
        this.autoChanged = autoChanged;
        this.updateBy = updateBy;
        this.updateByName = updateByName;
        this.conversationAssignmentLimit = conversationAssignmentLimit;
        this.ticketAssignmentLimit = ticketAssignmentLimit;
        this.team = team;
        this.teamAssignmentLimit = teamAssignmentLimit;
        this.enabled = enabled;
        this.consentId = consentId;
        this.expiredAt = expiredAt;
        this.before = before;
        this.after = after;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The way the admin signed in.
     */
    @JsonProperty("sign_in_method")
    public Optional<String> getSignInMethod() {
        return signInMethod;
    }

    /**
     * @return The unique identifier for the contact which is provided by the Client.
     */
    @JsonProperty("external_id")
    public Optional<String> getExternalId() {
        return externalId;
    }

    /**
     * @return The away mode status which is set to true when away and false when returned.
     */
    @JsonProperty("away_mode")
    public Optional<Boolean> getAwayMode() {
        return awayMode;
    }

    /**
     * @return The reason the Admin is away.
     */
    @JsonProperty("away_status_reason")
    public Optional<String> getAwayStatusReason() {
        return awayStatusReason;
    }

    /**
     * @return Indicates if conversations should be reassigned while an Admin is away.
     */
    @JsonProperty("reassign_conversations")
    public Optional<Boolean> getReassignConversations() {
        return reassignConversations;
    }

    /**
     * @return The action that initiated the status change.
     */
    @JsonProperty("source")
    public Optional<String> getSource() {
        return source;
    }

    /**
     * @return Indicates if the status was changed automatically or manually.
     */
    @JsonProperty("auto_changed")
    public Optional<String> getAutoChanged() {
        return autoChanged;
    }

    /**
     * @return The ID of the Admin who initiated the activity.
     */
    @JsonProperty("update_by")
    public Optional<Integer> getUpdateBy() {
        return updateBy;
    }

    /**
     * @return The name of the Admin who initiated the activity.
     */
    @JsonProperty("update_by_name")
    public Optional<String> getUpdateByName() {
        return updateByName;
    }

    /**
     * @return The conversation assignment limit value for an admin.
     */
    @JsonProperty("conversation_assignment_limit")
    public Optional<Integer> getConversationAssignmentLimit() {
        return conversationAssignmentLimit;
    }

    /**
     * @return The ticket assignment limit value for an admin.
     */
    @JsonProperty("ticket_assignment_limit")
    public Optional<Integer> getTicketAssignmentLimit() {
        return ticketAssignmentLimit;
    }

    /**
     * @return Details about the team whose assignment limit was changed.
     */
    @JsonProperty("team")
    public Optional<Team> getTeam() {
        return team;
    }

    /**
     * @return The team assignment limit value (null if limit was removed).
     */
    @JsonProperty("team_assignment_limit")
    public Optional<Integer> getTeamAssignmentLimit() {
        return teamAssignmentLimit;
    }

    /**
     * @return Indicates if the setting is enabled or disabled.
     */
    @JsonProperty("enabled")
    public Optional<Boolean> getEnabled() {
        return enabled;
    }

    /**
     * @return The ID of the impersonation consent.
     */
    @JsonProperty("consent_id")
    public Optional<Integer> getConsentId() {
        return consentId;
    }

    /**
     * @return The timestamp when the impersonation consent expires.
     */
    @JsonProperty("expired_at")
    public Optional<OffsetDateTime> getExpiredAt() {
        return expiredAt;
    }

    /**
     * @return The state of settings or values before the change. Structure varies by activity type.
     */
    @JsonProperty("before")
    public Optional<Map<String, Object>> getBefore() {
        return before;
    }

    /**
     * @return The state of settings or values after the change. Structure varies by activity type.
     */
    @JsonProperty("after")
    public Optional<Map<String, Object>> getAfter() {
        return after;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ActivityLogMetadata && equalTo((ActivityLogMetadata) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ActivityLogMetadata other) {
        return signInMethod.equals(other.signInMethod)
                && externalId.equals(other.externalId)
                && awayMode.equals(other.awayMode)
                && awayStatusReason.equals(other.awayStatusReason)
                && reassignConversations.equals(other.reassignConversations)
                && source.equals(other.source)
                && autoChanged.equals(other.autoChanged)
                && updateBy.equals(other.updateBy)
                && updateByName.equals(other.updateByName)
                && conversationAssignmentLimit.equals(other.conversationAssignmentLimit)
                && ticketAssignmentLimit.equals(other.ticketAssignmentLimit)
                && team.equals(other.team)
                && teamAssignmentLimit.equals(other.teamAssignmentLimit)
                && enabled.equals(other.enabled)
                && consentId.equals(other.consentId)
                && expiredAt.equals(other.expiredAt)
                && before.equals(other.before)
                && after.equals(other.after);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.signInMethod,
                this.externalId,
                this.awayMode,
                this.awayStatusReason,
                this.reassignConversations,
                this.source,
                this.autoChanged,
                this.updateBy,
                this.updateByName,
                this.conversationAssignmentLimit,
                this.ticketAssignmentLimit,
                this.team,
                this.teamAssignmentLimit,
                this.enabled,
                this.consentId,
                this.expiredAt,
                this.before,
                this.after);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> signInMethod = Optional.empty();

        private Optional<String> externalId = Optional.empty();

        private Optional<Boolean> awayMode = Optional.empty();

        private Optional<String> awayStatusReason = Optional.empty();

        private Optional<Boolean> reassignConversations = Optional.empty();

        private Optional<String> source = Optional.empty();

        private Optional<String> autoChanged = Optional.empty();

        private Optional<Integer> updateBy = Optional.empty();

        private Optional<String> updateByName = Optional.empty();

        private Optional<Integer> conversationAssignmentLimit = Optional.empty();

        private Optional<Integer> ticketAssignmentLimit = Optional.empty();

        private Optional<Team> team = Optional.empty();

        private Optional<Integer> teamAssignmentLimit = Optional.empty();

        private Optional<Boolean> enabled = Optional.empty();

        private Optional<Integer> consentId = Optional.empty();

        private Optional<OffsetDateTime> expiredAt = Optional.empty();

        private Optional<Map<String, Object>> before = Optional.empty();

        private Optional<Map<String, Object>> after = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ActivityLogMetadata other) {
            signInMethod(other.getSignInMethod());
            externalId(other.getExternalId());
            awayMode(other.getAwayMode());
            awayStatusReason(other.getAwayStatusReason());
            reassignConversations(other.getReassignConversations());
            source(other.getSource());
            autoChanged(other.getAutoChanged());
            updateBy(other.getUpdateBy());
            updateByName(other.getUpdateByName());
            conversationAssignmentLimit(other.getConversationAssignmentLimit());
            ticketAssignmentLimit(other.getTicketAssignmentLimit());
            team(other.getTeam());
            teamAssignmentLimit(other.getTeamAssignmentLimit());
            enabled(other.getEnabled());
            consentId(other.getConsentId());
            expiredAt(other.getExpiredAt());
            before(other.getBefore());
            after(other.getAfter());
            return this;
        }

        /**
         * <p>The way the admin signed in.</p>
         */
        @JsonSetter(value = "sign_in_method", nulls = Nulls.SKIP)
        public Builder signInMethod(Optional<String> signInMethod) {
            this.signInMethod = signInMethod;
            return this;
        }

        public Builder signInMethod(String signInMethod) {
            this.signInMethod = Optional.ofNullable(signInMethod);
            return this;
        }

        /**
         * <p>The unique identifier for the contact which is provided by the Client.</p>
         */
        @JsonSetter(value = "external_id", nulls = Nulls.SKIP)
        public Builder externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        /**
         * <p>The away mode status which is set to true when away and false when returned.</p>
         */
        @JsonSetter(value = "away_mode", nulls = Nulls.SKIP)
        public Builder awayMode(Optional<Boolean> awayMode) {
            this.awayMode = awayMode;
            return this;
        }

        public Builder awayMode(Boolean awayMode) {
            this.awayMode = Optional.ofNullable(awayMode);
            return this;
        }

        /**
         * <p>The reason the Admin is away.</p>
         */
        @JsonSetter(value = "away_status_reason", nulls = Nulls.SKIP)
        public Builder awayStatusReason(Optional<String> awayStatusReason) {
            this.awayStatusReason = awayStatusReason;
            return this;
        }

        public Builder awayStatusReason(String awayStatusReason) {
            this.awayStatusReason = Optional.ofNullable(awayStatusReason);
            return this;
        }

        /**
         * <p>Indicates if conversations should be reassigned while an Admin is away.</p>
         */
        @JsonSetter(value = "reassign_conversations", nulls = Nulls.SKIP)
        public Builder reassignConversations(Optional<Boolean> reassignConversations) {
            this.reassignConversations = reassignConversations;
            return this;
        }

        public Builder reassignConversations(Boolean reassignConversations) {
            this.reassignConversations = Optional.ofNullable(reassignConversations);
            return this;
        }

        /**
         * <p>The action that initiated the status change.</p>
         */
        @JsonSetter(value = "source", nulls = Nulls.SKIP)
        public Builder source(Optional<String> source) {
            this.source = source;
            return this;
        }

        public Builder source(String source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        /**
         * <p>Indicates if the status was changed automatically or manually.</p>
         */
        @JsonSetter(value = "auto_changed", nulls = Nulls.SKIP)
        public Builder autoChanged(Optional<String> autoChanged) {
            this.autoChanged = autoChanged;
            return this;
        }

        public Builder autoChanged(String autoChanged) {
            this.autoChanged = Optional.ofNullable(autoChanged);
            return this;
        }

        /**
         * <p>The ID of the Admin who initiated the activity.</p>
         */
        @JsonSetter(value = "update_by", nulls = Nulls.SKIP)
        public Builder updateBy(Optional<Integer> updateBy) {
            this.updateBy = updateBy;
            return this;
        }

        public Builder updateBy(Integer updateBy) {
            this.updateBy = Optional.ofNullable(updateBy);
            return this;
        }

        /**
         * <p>The name of the Admin who initiated the activity.</p>
         */
        @JsonSetter(value = "update_by_name", nulls = Nulls.SKIP)
        public Builder updateByName(Optional<String> updateByName) {
            this.updateByName = updateByName;
            return this;
        }

        public Builder updateByName(String updateByName) {
            this.updateByName = Optional.ofNullable(updateByName);
            return this;
        }

        /**
         * <p>The conversation assignment limit value for an admin.</p>
         */
        @JsonSetter(value = "conversation_assignment_limit", nulls = Nulls.SKIP)
        public Builder conversationAssignmentLimit(Optional<Integer> conversationAssignmentLimit) {
            this.conversationAssignmentLimit = conversationAssignmentLimit;
            return this;
        }

        public Builder conversationAssignmentLimit(Integer conversationAssignmentLimit) {
            this.conversationAssignmentLimit = Optional.ofNullable(conversationAssignmentLimit);
            return this;
        }

        /**
         * <p>The ticket assignment limit value for an admin.</p>
         */
        @JsonSetter(value = "ticket_assignment_limit", nulls = Nulls.SKIP)
        public Builder ticketAssignmentLimit(Optional<Integer> ticketAssignmentLimit) {
            this.ticketAssignmentLimit = ticketAssignmentLimit;
            return this;
        }

        public Builder ticketAssignmentLimit(Integer ticketAssignmentLimit) {
            this.ticketAssignmentLimit = Optional.ofNullable(ticketAssignmentLimit);
            return this;
        }

        /**
         * <p>Details about the team whose assignment limit was changed.</p>
         */
        @JsonSetter(value = "team", nulls = Nulls.SKIP)
        public Builder team(Optional<Team> team) {
            this.team = team;
            return this;
        }

        public Builder team(Team team) {
            this.team = Optional.ofNullable(team);
            return this;
        }

        /**
         * <p>The team assignment limit value (null if limit was removed).</p>
         */
        @JsonSetter(value = "team_assignment_limit", nulls = Nulls.SKIP)
        public Builder teamAssignmentLimit(Optional<Integer> teamAssignmentLimit) {
            this.teamAssignmentLimit = teamAssignmentLimit;
            return this;
        }

        public Builder teamAssignmentLimit(Integer teamAssignmentLimit) {
            this.teamAssignmentLimit = Optional.ofNullable(teamAssignmentLimit);
            return this;
        }

        /**
         * <p>Indicates if the setting is enabled or disabled.</p>
         */
        @JsonSetter(value = "enabled", nulls = Nulls.SKIP)
        public Builder enabled(Optional<Boolean> enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = Optional.ofNullable(enabled);
            return this;
        }

        /**
         * <p>The ID of the impersonation consent.</p>
         */
        @JsonSetter(value = "consent_id", nulls = Nulls.SKIP)
        public Builder consentId(Optional<Integer> consentId) {
            this.consentId = consentId;
            return this;
        }

        public Builder consentId(Integer consentId) {
            this.consentId = Optional.ofNullable(consentId);
            return this;
        }

        /**
         * <p>The timestamp when the impersonation consent expires.</p>
         */
        @JsonSetter(value = "expired_at", nulls = Nulls.SKIP)
        public Builder expiredAt(Optional<OffsetDateTime> expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        public Builder expiredAt(OffsetDateTime expiredAt) {
            this.expiredAt = Optional.ofNullable(expiredAt);
            return this;
        }

        /**
         * <p>The state of settings or values before the change. Structure varies by activity type.</p>
         */
        @JsonSetter(value = "before", nulls = Nulls.SKIP)
        public Builder before(Optional<Map<String, Object>> before) {
            this.before = before;
            return this;
        }

        public Builder before(Map<String, Object> before) {
            this.before = Optional.ofNullable(before);
            return this;
        }

        /**
         * <p>The state of settings or values after the change. Structure varies by activity type.</p>
         */
        @JsonSetter(value = "after", nulls = Nulls.SKIP)
        public Builder after(Optional<Map<String, Object>> after) {
            this.after = after;
            return this;
        }

        public Builder after(Map<String, Object> after) {
            this.after = Optional.ofNullable(after);
            return this;
        }

        public ActivityLogMetadata build() {
            return new ActivityLogMetadata(
                    signInMethod,
                    externalId,
                    awayMode,
                    awayStatusReason,
                    reassignConversations,
                    source,
                    autoChanged,
                    updateBy,
                    updateByName,
                    conversationAssignmentLimit,
                    ticketAssignmentLimit,
                    team,
                    teamAssignmentLimit,
                    enabled,
                    consentId,
                    expiredAt,
                    before,
                    after,
                    additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Team.Builder.class)
    public static final class Team {
        private final Optional<Integer> id;

        private final Optional<String> name;

        private final Map<String, Object> additionalProperties;

        private Team(Optional<Integer> id, Optional<String> name, Map<String, Object> additionalProperties) {
            this.id = id;
            this.name = name;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The ID of the team.
         */
        @JsonProperty("id")
        public Optional<Integer> getId() {
            return id;
        }

        /**
         * @return The name of the team.
         */
        @JsonProperty("name")
        public Optional<String> getName() {
            return name;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Team && equalTo((Team) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Team other) {
            return id.equals(other.id) && name.equals(other.name);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<Integer> id = Optional.empty();

            private Optional<String> name = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Team other) {
                id(other.getId());
                name(other.getName());
                return this;
            }

            /**
             * <p>The ID of the team.</p>
             */
            @JsonSetter(value = "id", nulls = Nulls.SKIP)
            public Builder id(Optional<Integer> id) {
                this.id = id;
                return this;
            }

            public Builder id(Integer id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            /**
             * <p>The name of the team.</p>
             */
            @JsonSetter(value = "name", nulls = Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Team build() {
                return new Team(id, name, additionalProperties);
            }
        }
    }
}
