/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ArticleContent.Builder.class)
public final class ArticleContent {
    private final Optional<String> type;

    private final Optional<String> title;

    private final Optional<String> description;

    private final Optional<String> body;

    private final Optional<Integer> authorId;

    private final Optional<State> state;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<String> url;

    private final Map<String, Object> additionalProperties;

    private ArticleContent(
            Optional<String> type,
            Optional<String> title,
            Optional<String> description,
            Optional<String> body,
            Optional<Integer> authorId,
            Optional<State> state,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<String> url,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.title = title;
        this.description = description;
        this.body = body;
        this.authorId = authorId;
        this.state = state;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object - <code>article_content</code> .
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The title of the article.
     */
    @JsonProperty("title")
    public Optional<String> getTitle() {
        return title;
    }

    /**
     * @return The description of the article.
     */
    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    /**
     * @return The body of the article.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The ID of the author of the article.
     */
    @JsonProperty("author_id")
    public Optional<Integer> getAuthorId() {
        return authorId;
    }

    /**
     * @return Whether the article is <code>published</code> or is a <code>draft</code> .
     */
    @JsonProperty("state")
    public Optional<State> getState() {
        return state;
    }

    /**
     * @return The time when the article was created (seconds).
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time when the article was last updated (seconds).
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The URL of the article.
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ArticleContent && equalTo((ArticleContent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleContent other) {
        return type.equals(other.type)
                && title.equals(other.title)
                && description.equals(other.description)
                && body.equals(other.body)
                && authorId.equals(other.authorId)
                && state.equals(other.state)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && url.equals(other.url);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.title,
                this.description,
                this.body,
                this.authorId,
                this.state,
                this.createdAt,
                this.updatedAt,
                this.url);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> title = Optional.empty();

        private Optional<String> description = Optional.empty();

        private Optional<String> body = Optional.empty();

        private Optional<Integer> authorId = Optional.empty();

        private Optional<State> state = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<String> url = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ArticleContent other) {
            type(other.getType());
            title(other.getTitle());
            description(other.getDescription());
            body(other.getBody());
            authorId(other.getAuthorId());
            state(other.getState());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            url(other.getUrl());
            return this;
        }

        /**
         * <p>The type of object - <code>article_content</code> .</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The title of the article.</p>
         */
        @JsonSetter(value = "title", nulls = Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        /**
         * <p>The description of the article.</p>
         */
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * <p>The body of the article.</p>
         */
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The ID of the author of the article.</p>
         */
        @JsonSetter(value = "author_id", nulls = Nulls.SKIP)
        public Builder authorId(Optional<Integer> authorId) {
            this.authorId = authorId;
            return this;
        }

        public Builder authorId(Integer authorId) {
            this.authorId = Optional.ofNullable(authorId);
            return this;
        }

        /**
         * <p>Whether the article is <code>published</code> or is a <code>draft</code> .</p>
         */
        @JsonSetter(value = "state", nulls = Nulls.SKIP)
        public Builder state(Optional<State> state) {
            this.state = state;
            return this;
        }

        public Builder state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        /**
         * <p>The time when the article was created (seconds).</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time when the article was last updated (seconds).</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The URL of the article.</p>
         */
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        public ArticleContent build() {
            return new ArticleContent(
                    type, title, description, body, authorId, state, createdAt, updatedAt, url, additionalProperties);
        }
    }

    public static final class State {
        public static final State PUBLISHED = new State(Value.PUBLISHED, "published");

        public static final State DRAFT = new State(Value.DRAFT, "draft");

        private final Value value;

        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof State && this.string.equals(((State) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case PUBLISHED:
                    return visitor.visitPublished();
                case DRAFT:
                    return visitor.visitDraft();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "published":
                    return PUBLISHED;
                case "draft":
                    return DRAFT;
                default:
                    return new State(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            PUBLISHED,

            DRAFT,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitPublished();

            T visitDraft();

            T visitUnknown(String unknownType);
        }
    }
}
