/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationAttributeUpdatedByWorkflow.Builder.class)
public final class ConversationAttributeUpdatedByWorkflow {
    private final Optional<Workflow> workflow;

    private final Optional<Attribute> attribute;

    private final Optional<Value> value;

    private final Map<String, Object> additionalProperties;

    private ConversationAttributeUpdatedByWorkflow(
            Optional<Workflow> workflow,
            Optional<Attribute> attribute,
            Optional<Value> value,
            Map<String, Object> additionalProperties) {
        this.workflow = workflow;
        this.attribute = attribute;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("workflow")
    public Optional<Workflow> getWorkflow() {
        return workflow;
    }

    @JsonProperty("attribute")
    public Optional<Attribute> getAttribute() {
        return attribute;
    }

    @JsonProperty("value")
    public Optional<Value> getValue() {
        return value;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationAttributeUpdatedByWorkflow
                && equalTo((ConversationAttributeUpdatedByWorkflow) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationAttributeUpdatedByWorkflow other) {
        return workflow.equals(other.workflow) && attribute.equals(other.attribute) && value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.workflow, this.attribute, this.value);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Workflow> workflow = Optional.empty();

        private Optional<Attribute> attribute = Optional.empty();

        private Optional<Value> value = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ConversationAttributeUpdatedByWorkflow other) {
            workflow(other.getWorkflow());
            attribute(other.getAttribute());
            value(other.getValue());
            return this;
        }

        @JsonSetter(value = "workflow", nulls = Nulls.SKIP)
        public Builder workflow(Optional<Workflow> workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder workflow(Workflow workflow) {
            this.workflow = Optional.ofNullable(workflow);
            return this;
        }

        @JsonSetter(value = "attribute", nulls = Nulls.SKIP)
        public Builder attribute(Optional<Attribute> attribute) {
            this.attribute = attribute;
            return this;
        }

        public Builder attribute(Attribute attribute) {
            this.attribute = Optional.ofNullable(attribute);
            return this;
        }

        @JsonSetter(value = "value", nulls = Nulls.SKIP)
        public Builder value(Optional<Value> value) {
            this.value = value;
            return this;
        }

        public Builder value(Value value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        public ConversationAttributeUpdatedByWorkflow build() {
            return new ConversationAttributeUpdatedByWorkflow(workflow, attribute, value, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Workflow.Builder.class)
    public static final class Workflow {
        private final Optional<String> name;

        private final Map<String, Object> additionalProperties;

        private Workflow(Optional<String> name, Map<String, Object> additionalProperties) {
            this.name = name;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return Name of the workflow
         */
        @JsonProperty("name")
        public Optional<String> getName() {
            return name;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Workflow && equalTo((Workflow) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Workflow other) {
            return name.equals(other.name);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.name);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> name = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Workflow other) {
                name(other.getName());
                return this;
            }

            /**
             * <p>Name of the workflow</p>
             */
            @JsonSetter(value = "name", nulls = Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Workflow build() {
                return new Workflow(name, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Attribute.Builder.class)
    public static final class Attribute {
        private final Optional<String> name;

        private final Map<String, Object> additionalProperties;

        private Attribute(Optional<String> name, Map<String, Object> additionalProperties) {
            this.name = name;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return Name of the CDA updated
         */
        @JsonProperty("name")
        public Optional<String> getName() {
            return name;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Attribute && equalTo((Attribute) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Attribute other) {
            return name.equals(other.name);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.name);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> name = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Attribute other) {
                name(other.getName());
                return this;
            }

            /**
             * <p>Name of the CDA updated</p>
             */
            @JsonSetter(value = "name", nulls = Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Attribute build() {
                return new Attribute(name, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Value.Builder.class)
    public static final class Value {
        private final Optional<String> name;

        private final Map<String, Object> additionalProperties;

        private Value(Optional<String> name, Map<String, Object> additionalProperties) {
            this.name = name;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return Value of the CDA updated
         */
        @JsonProperty("name")
        public Optional<String> getName() {
            return name;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Value && equalTo((Value) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Value other) {
            return name.equals(other.name);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.name);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> name = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Value other) {
                name(other.getName());
                return this;
            }

            /**
             * <p>Value of the CDA updated</p>
             */
            @JsonSetter(value = "name", nulls = Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Value build() {
                return new Value(name, additionalProperties);
            }
        }
    }
}
