/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreatePhoneSwitchRequest.Builder.class)
public final class CreatePhoneSwitchRequest {
    private final String phone;

    private final Optional<Map<String, CustomAttributesValue>> customAttributes;

    private final Map<String, Object> additionalProperties;

    private CreatePhoneSwitchRequest(
            String phone,
            Optional<Map<String, CustomAttributesValue>> customAttributes,
            Map<String, Object> additionalProperties) {
        this.phone = phone;
        this.customAttributes = customAttributes;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Phone number in E.164 format, that will receive the SMS to continue the conversation in the Messenger.
     */
    @JsonProperty("phone")
    public String getPhone() {
        return phone;
    }

    @JsonProperty("custom_attributes")
    public Optional<Map<String, CustomAttributesValue>> getCustomAttributes() {
        return customAttributes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreatePhoneSwitchRequest && equalTo((CreatePhoneSwitchRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreatePhoneSwitchRequest other) {
        return phone.equals(other.phone) && customAttributes.equals(other.customAttributes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.phone, this.customAttributes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PhoneStage builder() {
        return new Builder();
    }

    public interface PhoneStage {
        /**
         * <p>Phone number in E.164 format, that will receive the SMS to continue the conversation in the Messenger.</p>
         */
        _FinalStage phone(@NotNull String phone);

        Builder from(CreatePhoneSwitchRequest other);
    }

    public interface _FinalStage {
        CreatePhoneSwitchRequest build();

        _FinalStage customAttributes(Optional<Map<String, CustomAttributesValue>> customAttributes);

        _FinalStage customAttributes(Map<String, CustomAttributesValue> customAttributes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PhoneStage, _FinalStage {
        private String phone;

        private Optional<Map<String, CustomAttributesValue>> customAttributes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreatePhoneSwitchRequest other) {
            phone(other.getPhone());
            customAttributes(other.getCustomAttributes());
            return this;
        }

        /**
         * <p>Phone number in E.164 format, that will receive the SMS to continue the conversation in the Messenger.</p>
         * <p>Phone number in E.164 format, that will receive the SMS to continue the conversation in the Messenger.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("phone")
        public _FinalStage phone(@NotNull String phone) {
            this.phone = Objects.requireNonNull(phone, "phone must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage customAttributes(Map<String, CustomAttributesValue> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, CustomAttributesValue>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        @java.lang.Override
        public CreatePhoneSwitchRequest build() {
            return new CreatePhoneSwitchRequest(phone, customAttributes, additionalProperties);
        }
    }

    @JsonDeserialize(using = CustomAttributesValue.Deserializer.class)
    public static final class CustomAttributesValue {
        private final Object value;

        private final int type;

        private CustomAttributesValue(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        @SuppressWarnings("unchecked")
        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((String) this.value);
            } else if (this.type == 1) {
                return visitor.visit((int) this.value);
            } else if (this.type == 2) {
                return visitor.visit((Datetime) this.value);
            } else if (this.type == 3) {
                return visitor.visit((CustomObjectInstanceList) this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof CustomAttributesValue && equalTo((CustomAttributesValue) other);
        }

        private boolean equalTo(CustomAttributesValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return this.value.toString();
        }

        public static CustomAttributesValue of(String value) {
            return new CustomAttributesValue(value, 0);
        }

        public static CustomAttributesValue of(int value) {
            return new CustomAttributesValue(value, 1);
        }

        public static CustomAttributesValue of(Datetime value) {
            return new CustomAttributesValue(value, 2);
        }

        public static CustomAttributesValue of(CustomObjectInstanceList value) {
            return new CustomAttributesValue(value, 3);
        }

        public interface Visitor<T> {
            T visit(String value);

            T visit(int value);

            T visit(Datetime value);

            T visit(CustomObjectInstanceList value);
        }

        static final class Deserializer extends StdDeserializer<CustomAttributesValue> {
            Deserializer() {
                super(CustomAttributesValue.class);
            }

            @java.lang.Override
            public CustomAttributesValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
                } catch (RuntimeException e) {
                }
                if (value instanceof Integer) {
                    return of((Integer) value);
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, Datetime.class));
                } catch (RuntimeException e) {
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, CustomObjectInstanceList.class));
                } catch (RuntimeException e) {
                }
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }
    }
}
