/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CustomChannelContact.Builder.class)
public final class CustomChannelContact {
    private final Type type;

    private final String externalId;

    private final Optional<String> name;

    private final Optional<String> email;

    private final Map<String, Object> additionalProperties;

    private CustomChannelContact(
            Type type,
            String externalId,
            Optional<String> name,
            Optional<String> email,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.externalId = externalId;
        this.name = name;
        this.email = email;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Type of contact, must be &quot;user&quot; or &quot;lead&quot;.
     */
    @JsonProperty("type")
    public Type getType() {
        return type;
    }

    /**
     * @return External identifier for the contact. Intercom will take care of the mapping of your external_id with our internal ones so you don't have to worry about it.
     */
    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    /**
     * @return Name of the contact. Required for user type.
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return Email address of the contact. Required for user type.
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CustomChannelContact && equalTo((CustomChannelContact) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomChannelContact other) {
        return type.equals(other.type)
                && externalId.equals(other.externalId)
                && name.equals(other.name)
                && email.equals(other.email);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.externalId, this.name, this.email);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * <p>Type of contact, must be &quot;user&quot; or &quot;lead&quot;.</p>
         */
        ExternalIdStage type(@NotNull Type type);

        Builder from(CustomChannelContact other);
    }

    public interface ExternalIdStage {
        /**
         * <p>External identifier for the contact. Intercom will take care of the mapping of your external_id with our internal ones so you don't have to worry about it.</p>
         */
        _FinalStage externalId(@NotNull String externalId);
    }

    public interface _FinalStage {
        CustomChannelContact build();

        /**
         * <p>Name of the contact. Required for user type.</p>
         */
        _FinalStage name(Optional<String> name);

        _FinalStage name(String name);

        /**
         * <p>Email address of the contact. Required for user type.</p>
         */
        _FinalStage email(Optional<String> email);

        _FinalStage email(String email);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, ExternalIdStage, _FinalStage {
        private Type type;

        private String externalId;

        private Optional<String> email = Optional.empty();

        private Optional<String> name = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CustomChannelContact other) {
            type(other.getType());
            externalId(other.getExternalId());
            name(other.getName());
            email(other.getEmail());
            return this;
        }

        /**
         * <p>Type of contact, must be &quot;user&quot; or &quot;lead&quot;.</p>
         * <p>Type of contact, must be &quot;user&quot; or &quot;lead&quot;.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public ExternalIdStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>External identifier for the contact. Intercom will take care of the mapping of your external_id with our internal ones so you don't have to worry about it.</p>
         * <p>External identifier for the contact. Intercom will take care of the mapping of your external_id with our internal ones so you don't have to worry about it.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("external_id")
        public _FinalStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        /**
         * <p>Email address of the contact. Required for user type.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>Email address of the contact. Required for user type.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        /**
         * <p>Name of the contact. Required for user type.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>Name of the contact. Required for user type.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @java.lang.Override
        public CustomChannelContact build() {
            return new CustomChannelContact(type, externalId, name, email, additionalProperties);
        }
    }

    public static final class Type {
        public static final Type USER = new Type(Value.USER, "user");

        public static final Type LEAD = new Type(Value.LEAD, "lead");

        private final Value value;

        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case USER:
                    return visitor.visitUser();
                case LEAD:
                    return visitor.visitLead();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "user":
                    return USER;
                case "lead":
                    return LEAD;
                default:
                    return new Type(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            USER,

            LEAD,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitUser();

            T visitLead();

            T visitUnknown(String unknownType);
        }
    }
}
