/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CustomObjectInstanceDeleted.Builder.class)
public final class CustomObjectInstanceDeleted {
    private final Optional<String> object;

    private final Optional<String> id;

    private final Optional<Boolean> deleted;

    private final Map<String, Object> additionalProperties;

    private CustomObjectInstanceDeleted(
            Optional<String> object,
            Optional<String> id,
            Optional<Boolean> deleted,
            Map<String, Object> additionalProperties) {
        this.object = object;
        this.id = id;
        this.deleted = deleted;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier of the Custom Object type that defines the structure of the Custom Object instance.
     */
    @JsonProperty("object")
    public Optional<String> getObject() {
        return object;
    }

    /**
     * @return The Intercom defined id representing the Custom Object instance.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return Whether the Custom Object instance is deleted or not.
     */
    @JsonProperty("deleted")
    public Optional<Boolean> getDeleted() {
        return deleted;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CustomObjectInstanceDeleted && equalTo((CustomObjectInstanceDeleted) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomObjectInstanceDeleted other) {
        return object.equals(other.object) && id.equals(other.id) && deleted.equals(other.deleted);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.object, this.id, this.deleted);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> object = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<Boolean> deleted = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CustomObjectInstanceDeleted other) {
            object(other.getObject());
            id(other.getId());
            deleted(other.getDeleted());
            return this;
        }

        /**
         * <p>The unique identifier of the Custom Object type that defines the structure of the Custom Object instance.</p>
         */
        @JsonSetter(value = "object", nulls = Nulls.SKIP)
        public Builder object(Optional<String> object) {
            this.object = object;
            return this;
        }

        public Builder object(String object) {
            this.object = Optional.ofNullable(object);
            return this;
        }

        /**
         * <p>The Intercom defined id representing the Custom Object instance.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>Whether the Custom Object instance is deleted or not.</p>
         */
        @JsonSetter(value = "deleted", nulls = Nulls.SKIP)
        public Builder deleted(Optional<Boolean> deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder deleted(Boolean deleted) {
            this.deleted = Optional.ofNullable(deleted);
            return this;
        }

        public CustomObjectInstanceDeleted build() {
            return new CustomObjectInstanceDeleted(object, id, deleted, additionalProperties);
        }
    }
}
