/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = GroupTranslatedContent.Builder.class)
public final class GroupTranslatedContent {
    private final Optional<String> type;

    private final Optional<GroupContent> ar;

    private final Optional<GroupContent> bg;

    private final Optional<GroupContent> bs;

    private final Optional<GroupContent> ca;

    private final Optional<GroupContent> cs;

    private final Optional<GroupContent> da;

    private final Optional<GroupContent> de;

    private final Optional<GroupContent> el;

    private final Optional<GroupContent> en;

    private final Optional<GroupContent> es;

    private final Optional<GroupContent> et;

    private final Optional<GroupContent> fi;

    private final Optional<GroupContent> fr;

    private final Optional<GroupContent> he;

    private final Optional<GroupContent> hr;

    private final Optional<GroupContent> hu;

    private final Optional<GroupContent> id;

    private final Optional<GroupContent> it;

    private final Optional<GroupContent> ja;

    private final Optional<GroupContent> ko;

    private final Optional<GroupContent> lt;

    private final Optional<GroupContent> lv;

    private final Optional<GroupContent> mn;

    private final Optional<GroupContent> nb;

    private final Optional<GroupContent> nl;

    private final Optional<GroupContent> pl;

    private final Optional<GroupContent> pt;

    private final Optional<GroupContent> ro;

    private final Optional<GroupContent> ru;

    private final Optional<GroupContent> sl;

    private final Optional<GroupContent> sr;

    private final Optional<GroupContent> sv;

    private final Optional<GroupContent> tr;

    private final Optional<GroupContent> vi;

    private final Optional<GroupContent> ptBr;

    private final Optional<GroupContent> zhCn;

    private final Optional<GroupContent> zhTw;

    private final Map<String, Object> additionalProperties;

    private GroupTranslatedContent(
            Optional<String> type,
            Optional<GroupContent> ar,
            Optional<GroupContent> bg,
            Optional<GroupContent> bs,
            Optional<GroupContent> ca,
            Optional<GroupContent> cs,
            Optional<GroupContent> da,
            Optional<GroupContent> de,
            Optional<GroupContent> el,
            Optional<GroupContent> en,
            Optional<GroupContent> es,
            Optional<GroupContent> et,
            Optional<GroupContent> fi,
            Optional<GroupContent> fr,
            Optional<GroupContent> he,
            Optional<GroupContent> hr,
            Optional<GroupContent> hu,
            Optional<GroupContent> id,
            Optional<GroupContent> it,
            Optional<GroupContent> ja,
            Optional<GroupContent> ko,
            Optional<GroupContent> lt,
            Optional<GroupContent> lv,
            Optional<GroupContent> mn,
            Optional<GroupContent> nb,
            Optional<GroupContent> nl,
            Optional<GroupContent> pl,
            Optional<GroupContent> pt,
            Optional<GroupContent> ro,
            Optional<GroupContent> ru,
            Optional<GroupContent> sl,
            Optional<GroupContent> sr,
            Optional<GroupContent> sv,
            Optional<GroupContent> tr,
            Optional<GroupContent> vi,
            Optional<GroupContent> ptBr,
            Optional<GroupContent> zhCn,
            Optional<GroupContent> zhTw,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.ar = ar;
        this.bg = bg;
        this.bs = bs;
        this.ca = ca;
        this.cs = cs;
        this.da = da;
        this.de = de;
        this.el = el;
        this.en = en;
        this.es = es;
        this.et = et;
        this.fi = fi;
        this.fr = fr;
        this.he = he;
        this.hr = hr;
        this.hu = hu;
        this.id = id;
        this.it = it;
        this.ja = ja;
        this.ko = ko;
        this.lt = lt;
        this.lv = lv;
        this.mn = mn;
        this.nb = nb;
        this.nl = nl;
        this.pl = pl;
        this.pt = pt;
        this.ro = ro;
        this.ru = ru;
        this.sl = sl;
        this.sr = sr;
        this.sv = sv;
        this.tr = tr;
        this.vi = vi;
        this.ptBr = ptBr;
        this.zhCn = zhCn;
        this.zhTw = zhTw;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object - group_translated_content.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The content of the group in Arabic
     */
    @JsonProperty("ar")
    public Optional<GroupContent> getAr() {
        return ar;
    }

    /**
     * @return The content of the group in Bulgarian
     */
    @JsonProperty("bg")
    public Optional<GroupContent> getBg() {
        return bg;
    }

    /**
     * @return The content of the group in Bosnian
     */
    @JsonProperty("bs")
    public Optional<GroupContent> getBs() {
        return bs;
    }

    /**
     * @return The content of the group in Catalan
     */
    @JsonProperty("ca")
    public Optional<GroupContent> getCa() {
        return ca;
    }

    /**
     * @return The content of the group in Czech
     */
    @JsonProperty("cs")
    public Optional<GroupContent> getCs() {
        return cs;
    }

    /**
     * @return The content of the group in Danish
     */
    @JsonProperty("da")
    public Optional<GroupContent> getDa() {
        return da;
    }

    /**
     * @return The content of the group in German
     */
    @JsonProperty("de")
    public Optional<GroupContent> getDe() {
        return de;
    }

    /**
     * @return The content of the group in Greek
     */
    @JsonProperty("el")
    public Optional<GroupContent> getEl() {
        return el;
    }

    /**
     * @return The content of the group in English
     */
    @JsonProperty("en")
    public Optional<GroupContent> getEn() {
        return en;
    }

    /**
     * @return The content of the group in Spanish
     */
    @JsonProperty("es")
    public Optional<GroupContent> getEs() {
        return es;
    }

    /**
     * @return The content of the group in Estonian
     */
    @JsonProperty("et")
    public Optional<GroupContent> getEt() {
        return et;
    }

    /**
     * @return The content of the group in Finnish
     */
    @JsonProperty("fi")
    public Optional<GroupContent> getFi() {
        return fi;
    }

    /**
     * @return The content of the group in French
     */
    @JsonProperty("fr")
    public Optional<GroupContent> getFr() {
        return fr;
    }

    /**
     * @return The content of the group in Hebrew
     */
    @JsonProperty("he")
    public Optional<GroupContent> getHe() {
        return he;
    }

    /**
     * @return The content of the group in Croatian
     */
    @JsonProperty("hr")
    public Optional<GroupContent> getHr() {
        return hr;
    }

    /**
     * @return The content of the group in Hungarian
     */
    @JsonProperty("hu")
    public Optional<GroupContent> getHu() {
        return hu;
    }

    /**
     * @return The content of the group in Indonesian
     */
    @JsonProperty("id")
    public Optional<GroupContent> getId() {
        return id;
    }

    /**
     * @return The content of the group in Italian
     */
    @JsonProperty("it")
    public Optional<GroupContent> getIt() {
        return it;
    }

    /**
     * @return The content of the group in Japanese
     */
    @JsonProperty("ja")
    public Optional<GroupContent> getJa() {
        return ja;
    }

    /**
     * @return The content of the group in Korean
     */
    @JsonProperty("ko")
    public Optional<GroupContent> getKo() {
        return ko;
    }

    /**
     * @return The content of the group in Lithuanian
     */
    @JsonProperty("lt")
    public Optional<GroupContent> getLt() {
        return lt;
    }

    /**
     * @return The content of the group in Latvian
     */
    @JsonProperty("lv")
    public Optional<GroupContent> getLv() {
        return lv;
    }

    /**
     * @return The content of the group in Mongolian
     */
    @JsonProperty("mn")
    public Optional<GroupContent> getMn() {
        return mn;
    }

    /**
     * @return The content of the group in Norwegian
     */
    @JsonProperty("nb")
    public Optional<GroupContent> getNb() {
        return nb;
    }

    /**
     * @return The content of the group in Dutch
     */
    @JsonProperty("nl")
    public Optional<GroupContent> getNl() {
        return nl;
    }

    /**
     * @return The content of the group in Polish
     */
    @JsonProperty("pl")
    public Optional<GroupContent> getPl() {
        return pl;
    }

    /**
     * @return The content of the group in Portuguese (Portugal)
     */
    @JsonProperty("pt")
    public Optional<GroupContent> getPt() {
        return pt;
    }

    /**
     * @return The content of the group in Romanian
     */
    @JsonProperty("ro")
    public Optional<GroupContent> getRo() {
        return ro;
    }

    /**
     * @return The content of the group in Russian
     */
    @JsonProperty("ru")
    public Optional<GroupContent> getRu() {
        return ru;
    }

    /**
     * @return The content of the group in Slovenian
     */
    @JsonProperty("sl")
    public Optional<GroupContent> getSl() {
        return sl;
    }

    /**
     * @return The content of the group in Serbian
     */
    @JsonProperty("sr")
    public Optional<GroupContent> getSr() {
        return sr;
    }

    /**
     * @return The content of the group in Swedish
     */
    @JsonProperty("sv")
    public Optional<GroupContent> getSv() {
        return sv;
    }

    /**
     * @return The content of the group in Turkish
     */
    @JsonProperty("tr")
    public Optional<GroupContent> getTr() {
        return tr;
    }

    /**
     * @return The content of the group in Vietnamese
     */
    @JsonProperty("vi")
    public Optional<GroupContent> getVi() {
        return vi;
    }

    /**
     * @return The content of the group in Portuguese (Brazil)
     */
    @JsonProperty("pt-BR")
    public Optional<GroupContent> getPtBr() {
        return ptBr;
    }

    /**
     * @return The content of the group in Chinese (China)
     */
    @JsonProperty("zh-CN")
    public Optional<GroupContent> getZhCn() {
        return zhCn;
    }

    /**
     * @return The content of the group in Chinese (Taiwan)
     */
    @JsonProperty("zh-TW")
    public Optional<GroupContent> getZhTw() {
        return zhTw;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof GroupTranslatedContent && equalTo((GroupTranslatedContent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GroupTranslatedContent other) {
        return type.equals(other.type)
                && ar.equals(other.ar)
                && bg.equals(other.bg)
                && bs.equals(other.bs)
                && ca.equals(other.ca)
                && cs.equals(other.cs)
                && da.equals(other.da)
                && de.equals(other.de)
                && el.equals(other.el)
                && en.equals(other.en)
                && es.equals(other.es)
                && et.equals(other.et)
                && fi.equals(other.fi)
                && fr.equals(other.fr)
                && he.equals(other.he)
                && hr.equals(other.hr)
                && hu.equals(other.hu)
                && id.equals(other.id)
                && it.equals(other.it)
                && ja.equals(other.ja)
                && ko.equals(other.ko)
                && lt.equals(other.lt)
                && lv.equals(other.lv)
                && mn.equals(other.mn)
                && nb.equals(other.nb)
                && nl.equals(other.nl)
                && pl.equals(other.pl)
                && pt.equals(other.pt)
                && ro.equals(other.ro)
                && ru.equals(other.ru)
                && sl.equals(other.sl)
                && sr.equals(other.sr)
                && sv.equals(other.sv)
                && tr.equals(other.tr)
                && vi.equals(other.vi)
                && ptBr.equals(other.ptBr)
                && zhCn.equals(other.zhCn)
                && zhTw.equals(other.zhTw);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type, this.ar, this.bg, this.bs, this.ca, this.cs, this.da, this.de, this.el, this.en, this.es,
                this.et, this.fi, this.fr, this.he, this.hr, this.hu, this.id, this.it, this.ja, this.ko, this.lt,
                this.lv, this.mn, this.nb, this.nl, this.pl, this.pt, this.ro, this.ru, this.sl, this.sr, this.sv,
                this.tr, this.vi, this.ptBr, this.zhCn, this.zhTw);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<GroupContent> ar = Optional.empty();

        private Optional<GroupContent> bg = Optional.empty();

        private Optional<GroupContent> bs = Optional.empty();

        private Optional<GroupContent> ca = Optional.empty();

        private Optional<GroupContent> cs = Optional.empty();

        private Optional<GroupContent> da = Optional.empty();

        private Optional<GroupContent> de = Optional.empty();

        private Optional<GroupContent> el = Optional.empty();

        private Optional<GroupContent> en = Optional.empty();

        private Optional<GroupContent> es = Optional.empty();

        private Optional<GroupContent> et = Optional.empty();

        private Optional<GroupContent> fi = Optional.empty();

        private Optional<GroupContent> fr = Optional.empty();

        private Optional<GroupContent> he = Optional.empty();

        private Optional<GroupContent> hr = Optional.empty();

        private Optional<GroupContent> hu = Optional.empty();

        private Optional<GroupContent> id = Optional.empty();

        private Optional<GroupContent> it = Optional.empty();

        private Optional<GroupContent> ja = Optional.empty();

        private Optional<GroupContent> ko = Optional.empty();

        private Optional<GroupContent> lt = Optional.empty();

        private Optional<GroupContent> lv = Optional.empty();

        private Optional<GroupContent> mn = Optional.empty();

        private Optional<GroupContent> nb = Optional.empty();

        private Optional<GroupContent> nl = Optional.empty();

        private Optional<GroupContent> pl = Optional.empty();

        private Optional<GroupContent> pt = Optional.empty();

        private Optional<GroupContent> ro = Optional.empty();

        private Optional<GroupContent> ru = Optional.empty();

        private Optional<GroupContent> sl = Optional.empty();

        private Optional<GroupContent> sr = Optional.empty();

        private Optional<GroupContent> sv = Optional.empty();

        private Optional<GroupContent> tr = Optional.empty();

        private Optional<GroupContent> vi = Optional.empty();

        private Optional<GroupContent> ptBr = Optional.empty();

        private Optional<GroupContent> zhCn = Optional.empty();

        private Optional<GroupContent> zhTw = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(GroupTranslatedContent other) {
            type(other.getType());
            ar(other.getAr());
            bg(other.getBg());
            bs(other.getBs());
            ca(other.getCa());
            cs(other.getCs());
            da(other.getDa());
            de(other.getDe());
            el(other.getEl());
            en(other.getEn());
            es(other.getEs());
            et(other.getEt());
            fi(other.getFi());
            fr(other.getFr());
            he(other.getHe());
            hr(other.getHr());
            hu(other.getHu());
            id(other.getId());
            it(other.getIt());
            ja(other.getJa());
            ko(other.getKo());
            lt(other.getLt());
            lv(other.getLv());
            mn(other.getMn());
            nb(other.getNb());
            nl(other.getNl());
            pl(other.getPl());
            pt(other.getPt());
            ro(other.getRo());
            ru(other.getRu());
            sl(other.getSl());
            sr(other.getSr());
            sv(other.getSv());
            tr(other.getTr());
            vi(other.getVi());
            ptBr(other.getPtBr());
            zhCn(other.getZhCn());
            zhTw(other.getZhTw());
            return this;
        }

        /**
         * <p>The type of object - group_translated_content.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The content of the group in Arabic</p>
         */
        @JsonSetter(value = "ar", nulls = Nulls.SKIP)
        public Builder ar(Optional<GroupContent> ar) {
            this.ar = ar;
            return this;
        }

        public Builder ar(GroupContent ar) {
            this.ar = Optional.ofNullable(ar);
            return this;
        }

        /**
         * <p>The content of the group in Bulgarian</p>
         */
        @JsonSetter(value = "bg", nulls = Nulls.SKIP)
        public Builder bg(Optional<GroupContent> bg) {
            this.bg = bg;
            return this;
        }

        public Builder bg(GroupContent bg) {
            this.bg = Optional.ofNullable(bg);
            return this;
        }

        /**
         * <p>The content of the group in Bosnian</p>
         */
        @JsonSetter(value = "bs", nulls = Nulls.SKIP)
        public Builder bs(Optional<GroupContent> bs) {
            this.bs = bs;
            return this;
        }

        public Builder bs(GroupContent bs) {
            this.bs = Optional.ofNullable(bs);
            return this;
        }

        /**
         * <p>The content of the group in Catalan</p>
         */
        @JsonSetter(value = "ca", nulls = Nulls.SKIP)
        public Builder ca(Optional<GroupContent> ca) {
            this.ca = ca;
            return this;
        }

        public Builder ca(GroupContent ca) {
            this.ca = Optional.ofNullable(ca);
            return this;
        }

        /**
         * <p>The content of the group in Czech</p>
         */
        @JsonSetter(value = "cs", nulls = Nulls.SKIP)
        public Builder cs(Optional<GroupContent> cs) {
            this.cs = cs;
            return this;
        }

        public Builder cs(GroupContent cs) {
            this.cs = Optional.ofNullable(cs);
            return this;
        }

        /**
         * <p>The content of the group in Danish</p>
         */
        @JsonSetter(value = "da", nulls = Nulls.SKIP)
        public Builder da(Optional<GroupContent> da) {
            this.da = da;
            return this;
        }

        public Builder da(GroupContent da) {
            this.da = Optional.ofNullable(da);
            return this;
        }

        /**
         * <p>The content of the group in German</p>
         */
        @JsonSetter(value = "de", nulls = Nulls.SKIP)
        public Builder de(Optional<GroupContent> de) {
            this.de = de;
            return this;
        }

        public Builder de(GroupContent de) {
            this.de = Optional.ofNullable(de);
            return this;
        }

        /**
         * <p>The content of the group in Greek</p>
         */
        @JsonSetter(value = "el", nulls = Nulls.SKIP)
        public Builder el(Optional<GroupContent> el) {
            this.el = el;
            return this;
        }

        public Builder el(GroupContent el) {
            this.el = Optional.ofNullable(el);
            return this;
        }

        /**
         * <p>The content of the group in English</p>
         */
        @JsonSetter(value = "en", nulls = Nulls.SKIP)
        public Builder en(Optional<GroupContent> en) {
            this.en = en;
            return this;
        }

        public Builder en(GroupContent en) {
            this.en = Optional.ofNullable(en);
            return this;
        }

        /**
         * <p>The content of the group in Spanish</p>
         */
        @JsonSetter(value = "es", nulls = Nulls.SKIP)
        public Builder es(Optional<GroupContent> es) {
            this.es = es;
            return this;
        }

        public Builder es(GroupContent es) {
            this.es = Optional.ofNullable(es);
            return this;
        }

        /**
         * <p>The content of the group in Estonian</p>
         */
        @JsonSetter(value = "et", nulls = Nulls.SKIP)
        public Builder et(Optional<GroupContent> et) {
            this.et = et;
            return this;
        }

        public Builder et(GroupContent et) {
            this.et = Optional.ofNullable(et);
            return this;
        }

        /**
         * <p>The content of the group in Finnish</p>
         */
        @JsonSetter(value = "fi", nulls = Nulls.SKIP)
        public Builder fi(Optional<GroupContent> fi) {
            this.fi = fi;
            return this;
        }

        public Builder fi(GroupContent fi) {
            this.fi = Optional.ofNullable(fi);
            return this;
        }

        /**
         * <p>The content of the group in French</p>
         */
        @JsonSetter(value = "fr", nulls = Nulls.SKIP)
        public Builder fr(Optional<GroupContent> fr) {
            this.fr = fr;
            return this;
        }

        public Builder fr(GroupContent fr) {
            this.fr = Optional.ofNullable(fr);
            return this;
        }

        /**
         * <p>The content of the group in Hebrew</p>
         */
        @JsonSetter(value = "he", nulls = Nulls.SKIP)
        public Builder he(Optional<GroupContent> he) {
            this.he = he;
            return this;
        }

        public Builder he(GroupContent he) {
            this.he = Optional.ofNullable(he);
            return this;
        }

        /**
         * <p>The content of the group in Croatian</p>
         */
        @JsonSetter(value = "hr", nulls = Nulls.SKIP)
        public Builder hr(Optional<GroupContent> hr) {
            this.hr = hr;
            return this;
        }

        public Builder hr(GroupContent hr) {
            this.hr = Optional.ofNullable(hr);
            return this;
        }

        /**
         * <p>The content of the group in Hungarian</p>
         */
        @JsonSetter(value = "hu", nulls = Nulls.SKIP)
        public Builder hu(Optional<GroupContent> hu) {
            this.hu = hu;
            return this;
        }

        public Builder hu(GroupContent hu) {
            this.hu = Optional.ofNullable(hu);
            return this;
        }

        /**
         * <p>The content of the group in Indonesian</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<GroupContent> id) {
            this.id = id;
            return this;
        }

        public Builder id(GroupContent id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The content of the group in Italian</p>
         */
        @JsonSetter(value = "it", nulls = Nulls.SKIP)
        public Builder it(Optional<GroupContent> it) {
            this.it = it;
            return this;
        }

        public Builder it(GroupContent it) {
            this.it = Optional.ofNullable(it);
            return this;
        }

        /**
         * <p>The content of the group in Japanese</p>
         */
        @JsonSetter(value = "ja", nulls = Nulls.SKIP)
        public Builder ja(Optional<GroupContent> ja) {
            this.ja = ja;
            return this;
        }

        public Builder ja(GroupContent ja) {
            this.ja = Optional.ofNullable(ja);
            return this;
        }

        /**
         * <p>The content of the group in Korean</p>
         */
        @JsonSetter(value = "ko", nulls = Nulls.SKIP)
        public Builder ko(Optional<GroupContent> ko) {
            this.ko = ko;
            return this;
        }

        public Builder ko(GroupContent ko) {
            this.ko = Optional.ofNullable(ko);
            return this;
        }

        /**
         * <p>The content of the group in Lithuanian</p>
         */
        @JsonSetter(value = "lt", nulls = Nulls.SKIP)
        public Builder lt(Optional<GroupContent> lt) {
            this.lt = lt;
            return this;
        }

        public Builder lt(GroupContent lt) {
            this.lt = Optional.ofNullable(lt);
            return this;
        }

        /**
         * <p>The content of the group in Latvian</p>
         */
        @JsonSetter(value = "lv", nulls = Nulls.SKIP)
        public Builder lv(Optional<GroupContent> lv) {
            this.lv = lv;
            return this;
        }

        public Builder lv(GroupContent lv) {
            this.lv = Optional.ofNullable(lv);
            return this;
        }

        /**
         * <p>The content of the group in Mongolian</p>
         */
        @JsonSetter(value = "mn", nulls = Nulls.SKIP)
        public Builder mn(Optional<GroupContent> mn) {
            this.mn = mn;
            return this;
        }

        public Builder mn(GroupContent mn) {
            this.mn = Optional.ofNullable(mn);
            return this;
        }

        /**
         * <p>The content of the group in Norwegian</p>
         */
        @JsonSetter(value = "nb", nulls = Nulls.SKIP)
        public Builder nb(Optional<GroupContent> nb) {
            this.nb = nb;
            return this;
        }

        public Builder nb(GroupContent nb) {
            this.nb = Optional.ofNullable(nb);
            return this;
        }

        /**
         * <p>The content of the group in Dutch</p>
         */
        @JsonSetter(value = "nl", nulls = Nulls.SKIP)
        public Builder nl(Optional<GroupContent> nl) {
            this.nl = nl;
            return this;
        }

        public Builder nl(GroupContent nl) {
            this.nl = Optional.ofNullable(nl);
            return this;
        }

        /**
         * <p>The content of the group in Polish</p>
         */
        @JsonSetter(value = "pl", nulls = Nulls.SKIP)
        public Builder pl(Optional<GroupContent> pl) {
            this.pl = pl;
            return this;
        }

        public Builder pl(GroupContent pl) {
            this.pl = Optional.ofNullable(pl);
            return this;
        }

        /**
         * <p>The content of the group in Portuguese (Portugal)</p>
         */
        @JsonSetter(value = "pt", nulls = Nulls.SKIP)
        public Builder pt(Optional<GroupContent> pt) {
            this.pt = pt;
            return this;
        }

        public Builder pt(GroupContent pt) {
            this.pt = Optional.ofNullable(pt);
            return this;
        }

        /**
         * <p>The content of the group in Romanian</p>
         */
        @JsonSetter(value = "ro", nulls = Nulls.SKIP)
        public Builder ro(Optional<GroupContent> ro) {
            this.ro = ro;
            return this;
        }

        public Builder ro(GroupContent ro) {
            this.ro = Optional.ofNullable(ro);
            return this;
        }

        /**
         * <p>The content of the group in Russian</p>
         */
        @JsonSetter(value = "ru", nulls = Nulls.SKIP)
        public Builder ru(Optional<GroupContent> ru) {
            this.ru = ru;
            return this;
        }

        public Builder ru(GroupContent ru) {
            this.ru = Optional.ofNullable(ru);
            return this;
        }

        /**
         * <p>The content of the group in Slovenian</p>
         */
        @JsonSetter(value = "sl", nulls = Nulls.SKIP)
        public Builder sl(Optional<GroupContent> sl) {
            this.sl = sl;
            return this;
        }

        public Builder sl(GroupContent sl) {
            this.sl = Optional.ofNullable(sl);
            return this;
        }

        /**
         * <p>The content of the group in Serbian</p>
         */
        @JsonSetter(value = "sr", nulls = Nulls.SKIP)
        public Builder sr(Optional<GroupContent> sr) {
            this.sr = sr;
            return this;
        }

        public Builder sr(GroupContent sr) {
            this.sr = Optional.ofNullable(sr);
            return this;
        }

        /**
         * <p>The content of the group in Swedish</p>
         */
        @JsonSetter(value = "sv", nulls = Nulls.SKIP)
        public Builder sv(Optional<GroupContent> sv) {
            this.sv = sv;
            return this;
        }

        public Builder sv(GroupContent sv) {
            this.sv = Optional.ofNullable(sv);
            return this;
        }

        /**
         * <p>The content of the group in Turkish</p>
         */
        @JsonSetter(value = "tr", nulls = Nulls.SKIP)
        public Builder tr(Optional<GroupContent> tr) {
            this.tr = tr;
            return this;
        }

        public Builder tr(GroupContent tr) {
            this.tr = Optional.ofNullable(tr);
            return this;
        }

        /**
         * <p>The content of the group in Vietnamese</p>
         */
        @JsonSetter(value = "vi", nulls = Nulls.SKIP)
        public Builder vi(Optional<GroupContent> vi) {
            this.vi = vi;
            return this;
        }

        public Builder vi(GroupContent vi) {
            this.vi = Optional.ofNullable(vi);
            return this;
        }

        /**
         * <p>The content of the group in Portuguese (Brazil)</p>
         */
        @JsonSetter(value = "pt-BR", nulls = Nulls.SKIP)
        public Builder ptBr(Optional<GroupContent> ptBr) {
            this.ptBr = ptBr;
            return this;
        }

        public Builder ptBr(GroupContent ptBr) {
            this.ptBr = Optional.ofNullable(ptBr);
            return this;
        }

        /**
         * <p>The content of the group in Chinese (China)</p>
         */
        @JsonSetter(value = "zh-CN", nulls = Nulls.SKIP)
        public Builder zhCn(Optional<GroupContent> zhCn) {
            this.zhCn = zhCn;
            return this;
        }

        public Builder zhCn(GroupContent zhCn) {
            this.zhCn = Optional.ofNullable(zhCn);
            return this;
        }

        /**
         * <p>The content of the group in Chinese (Taiwan)</p>
         */
        @JsonSetter(value = "zh-TW", nulls = Nulls.SKIP)
        public Builder zhTw(Optional<GroupContent> zhTw) {
            this.zhTw = zhTw;
            return this;
        }

        public Builder zhTw(GroupContent zhTw) {
            this.zhTw = Optional.ofNullable(zhTw);
            return this;
        }

        public GroupTranslatedContent build() {
            return new GroupTranslatedContent(
                    type,
                    ar,
                    bg,
                    bs,
                    ca,
                    cs,
                    da,
                    de,
                    el,
                    en,
                    es,
                    et,
                    fi,
                    fr,
                    he,
                    hr,
                    hu,
                    id,
                    it,
                    ja,
                    ko,
                    lt,
                    lv,
                    mn,
                    nb,
                    nl,
                    pl,
                    pt,
                    ro,
                    ru,
                    sl,
                    sr,
                    sv,
                    tr,
                    vi,
                    ptBr,
                    zhCn,
                    zhTw,
                    additionalProperties);
        }
    }
}
