/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = OperatorWorkflowEvent.Builder.class)
public final class OperatorWorkflowEvent {
    private final Optional<Workflow> workflow;

    private final Optional<Event> event;

    private final Map<String, Object> additionalProperties;

    private OperatorWorkflowEvent(
            Optional<Workflow> workflow, Optional<Event> event, Map<String, Object> additionalProperties) {
        this.workflow = workflow;
        this.event = event;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("workflow")
    public Optional<Workflow> getWorkflow() {
        return workflow;
    }

    @JsonProperty("event")
    public Optional<Event> getEvent() {
        return event;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof OperatorWorkflowEvent && equalTo((OperatorWorkflowEvent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(OperatorWorkflowEvent other) {
        return workflow.equals(other.workflow) && event.equals(other.event);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.workflow, this.event);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Workflow> workflow = Optional.empty();

        private Optional<Event> event = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(OperatorWorkflowEvent other) {
            workflow(other.getWorkflow());
            event(other.getEvent());
            return this;
        }

        @JsonSetter(value = "workflow", nulls = Nulls.SKIP)
        public Builder workflow(Optional<Workflow> workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder workflow(Workflow workflow) {
            this.workflow = Optional.ofNullable(workflow);
            return this;
        }

        @JsonSetter(value = "event", nulls = Nulls.SKIP)
        public Builder event(Optional<Event> event) {
            this.event = event;
            return this;
        }

        public Builder event(Event event) {
            this.event = Optional.ofNullable(event);
            return this;
        }

        public OperatorWorkflowEvent build() {
            return new OperatorWorkflowEvent(workflow, event, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Event.Builder.class)
    public static final class Event {
        private final Optional<String> type;

        private final Optional<String> result;

        private final Map<String, Object> additionalProperties;

        private Event(Optional<String> type, Optional<String> result, Map<String, Object> additionalProperties) {
            this.type = type;
            this.result = result;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return Type of the workflow event initiated
         */
        @JsonProperty("type")
        public Optional<String> getType() {
            return type;
        }

        /**
         * @return Result of the workflow event
         */
        @JsonProperty("result")
        public Optional<String> getResult() {
            return result;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Event && equalTo((Event) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Event other) {
            return type.equals(other.type) && result.equals(other.result);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.result);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();

            private Optional<String> result = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Event other) {
                type(other.getType());
                result(other.getResult());
                return this;
            }

            /**
             * <p>Type of the workflow event initiated</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>Result of the workflow event</p>
             */
            @JsonSetter(value = "result", nulls = Nulls.SKIP)
            public Builder result(Optional<String> result) {
                this.result = result;
                return this;
            }

            public Builder result(String result) {
                this.result = Optional.ofNullable(result);
                return this;
            }

            public Event build() {
                return new Event(type, result, additionalProperties);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Workflow.Builder.class)
    public static final class Workflow {
        private final Optional<String> name;

        private final Map<String, Object> additionalProperties;

        private Workflow(Optional<String> name, Map<String, Object> additionalProperties) {
            this.name = name;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The name of the workflow
         */
        @JsonProperty("name")
        public Optional<String> getName() {
            return name;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Workflow && equalTo((Workflow) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Workflow other) {
            return name.equals(other.name);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.name);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> name = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(Workflow other) {
                name(other.getName());
                return this;
            }

            /**
             * <p>The name of the workflow</p>
             */
            @JsonSetter(value = "name", nulls = Nulls.SKIP)
            public Builder name(Optional<String> name) {
                this.name = name;
                return this;
            }

            public Builder name(String name) {
                this.name = Optional.ofNullable(name);
                return this;
            }

            public Workflow build() {
                return new Workflow(name, additionalProperties);
            }
        }
    }
}
