/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UntagCompanyRequest.Builder.class)
public final class UntagCompanyRequest {
    private final String name;

    private final List<CompaniesItem> companies;

    private final Map<String, Object> additionalProperties;

    private UntagCompanyRequest(String name, List<CompaniesItem> companies, Map<String, Object> additionalProperties) {
        this.name = name;
        this.companies = companies;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The name of the tag which will be untagged from the company
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The id or company_id of the company can be passed as input parameters.
     */
    @JsonProperty("companies")
    public List<CompaniesItem> getCompanies() {
        return companies;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UntagCompanyRequest && equalTo((UntagCompanyRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UntagCompanyRequest other) {
        return name.equals(other.name) && companies.equals(other.companies);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.name, this.companies);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        /**
         * <p>The name of the tag which will be untagged from the company</p>
         */
        _FinalStage name(@NotNull String name);

        Builder from(UntagCompanyRequest other);
    }

    public interface _FinalStage {
        UntagCompanyRequest build();

        /**
         * <p>The id or company_id of the company can be passed as input parameters.</p>
         */
        _FinalStage companies(List<CompaniesItem> companies);

        _FinalStage addCompanies(CompaniesItem companies);

        _FinalStage addAllCompanies(List<CompaniesItem> companies);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, _FinalStage {
        private String name;

        private List<CompaniesItem> companies = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UntagCompanyRequest other) {
            name(other.getName());
            companies(other.getCompanies());
            return this;
        }

        /**
         * <p>The name of the tag which will be untagged from the company</p>
         * <p>The name of the tag which will be untagged from the company</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * <p>The id or company_id of the company can be passed as input parameters.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllCompanies(List<CompaniesItem> companies) {
            if (companies != null) {
                this.companies.addAll(companies);
            }
            return this;
        }

        /**
         * <p>The id or company_id of the company can be passed as input parameters.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addCompanies(CompaniesItem companies) {
            this.companies.add(companies);
            return this;
        }

        /**
         * <p>The id or company_id of the company can be passed as input parameters.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "companies", nulls = Nulls.SKIP)
        public _FinalStage companies(List<CompaniesItem> companies) {
            this.companies.clear();
            if (companies != null) {
                this.companies.addAll(companies);
            }
            return this;
        }

        @java.lang.Override
        public UntagCompanyRequest build() {
            return new UntagCompanyRequest(name, companies, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = CompaniesItem.Builder.class)
    public static final class CompaniesItem {
        private final Optional<String> id;

        private final Optional<String> companyId;

        private final Optional<Boolean> untag;

        private final Map<String, Object> additionalProperties;

        private CompaniesItem(
                Optional<String> id,
                Optional<String> companyId,
                Optional<Boolean> untag,
                Map<String, Object> additionalProperties) {
            this.id = id;
            this.companyId = companyId;
            this.untag = untag;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The Intercom defined id representing the company.
         */
        @JsonProperty("id")
        public Optional<String> getId() {
            return id;
        }

        /**
         * @return The company id you have defined for the company.
         */
        @JsonProperty("company_id")
        public Optional<String> getCompanyId() {
            return companyId;
        }

        /**
         * @return Always set to true
         */
        @JsonProperty("untag")
        public Optional<Boolean> getUntag() {
            return untag;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof CompaniesItem && equalTo((CompaniesItem) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(CompaniesItem other) {
            return id.equals(other.id) && companyId.equals(other.companyId) && untag.equals(other.untag);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.id, this.companyId, this.untag);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<String> id = Optional.empty();

            private Optional<String> companyId = Optional.empty();

            private Optional<Boolean> untag = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(CompaniesItem other) {
                id(other.getId());
                companyId(other.getCompanyId());
                untag(other.getUntag());
                return this;
            }

            /**
             * <p>The Intercom defined id representing the company.</p>
             */
            @JsonSetter(value = "id", nulls = Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            /**
             * <p>The company id you have defined for the company.</p>
             */
            @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
            public Builder companyId(Optional<String> companyId) {
                this.companyId = companyId;
                return this;
            }

            public Builder companyId(String companyId) {
                this.companyId = Optional.ofNullable(companyId);
                return this;
            }

            /**
             * <p>Always set to true</p>
             */
            @JsonSetter(value = "untag", nulls = Nulls.SKIP)
            public Builder untag(Optional<Boolean> untag) {
                this.untag = untag;
                return this;
            }

            public Builder untag(Boolean untag) {
                this.untag = Optional.ofNullable(untag);
                return this;
            }

            public CompaniesItem build() {
                return new CompaniesItem(id, companyId, untag, additionalProperties);
            }
        }
    }
}
