/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.aicontent.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateExternalPageRequest {
    private final String pageId;
    private final String title;
    private final String html;
    private final String url;
    private final Optional<Boolean> finAvailability;
    private final int sourceId;
    private final Optional<String> externalId;
    private final Map<String, Object> additionalProperties;

    private UpdateExternalPageRequest(String pageId, String title, String html, String url, Optional<Boolean> finAvailability, int sourceId, Optional<String> externalId, Map<String, Object> additionalProperties) {
        this.pageId = pageId;
        this.title = title;
        this.html = html;
        this.url = url;
        this.finAvailability = finAvailability;
        this.sourceId = sourceId;
        this.externalId = externalId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="page_id")
    public String getPageId() {
        return this.pageId;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="html")
    public String getHtml() {
        return this.html;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="fin_availability")
    public Optional<Boolean> getFinAvailability() {
        return this.finAvailability;
    }

    @JsonProperty(value="locale")
    public String getLocale() {
        return "en";
    }

    @JsonProperty(value="source_id")
    public int getSourceId() {
        return this.sourceId;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateExternalPageRequest && this.equalTo((UpdateExternalPageRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateExternalPageRequest other) {
        return this.pageId.equals(other.pageId) && this.title.equals(other.title) && this.html.equals(other.html) && this.url.equals(other.url) && this.finAvailability.equals(other.finAvailability) && this.sourceId == other.sourceId && this.externalId.equals(other.externalId);
    }

    public int hashCode() {
        return Objects.hash(this.pageId, this.title, this.html, this.url, this.finAvailability, this.sourceId, this.externalId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PageIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PageIdStage,
    TitleStage,
    HtmlStage,
    UrlStage,
    SourceIdStage,
    _FinalStage {
        private String pageId;
        private String title;
        private String html;
        private String url;
        private int sourceId;
        private Optional<String> externalId = Optional.empty();
        private Optional<Boolean> finAvailability = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateExternalPageRequest other) {
            this.pageId(other.getPageId());
            this.title(other.getTitle());
            this.html(other.getHtml());
            this.url(other.getUrl());
            this.finAvailability(other.getFinAvailability());
            this.sourceId(other.getSourceId());
            this.externalId(other.getExternalId());
            return this;
        }

        @Override
        @JsonSetter(value="page_id")
        public TitleStage pageId(@NotNull String pageId) {
            this.pageId = Objects.requireNonNull(pageId, "pageId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public HtmlStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="html")
        public UrlStage html(@NotNull String html) {
            this.html = Objects.requireNonNull(html, "html must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public SourceIdStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="source_id")
        public _FinalStage sourceId(int sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        @Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @Override
        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public _FinalStage finAvailability(Boolean finAvailability) {
            this.finAvailability = Optional.ofNullable(finAvailability);
            return this;
        }

        @Override
        @JsonSetter(value="fin_availability", nulls=Nulls.SKIP)
        public _FinalStage finAvailability(Optional<Boolean> finAvailability) {
            this.finAvailability = finAvailability;
            return this;
        }

        @Override
        public UpdateExternalPageRequest build() {
            return new UpdateExternalPageRequest(this.pageId, this.title, this.html, this.url, this.finAvailability, this.sourceId, this.externalId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateExternalPageRequest build();

        public _FinalStage finAvailability(Optional<Boolean> var1);

        public _FinalStage finAvailability(Boolean var1);

        public _FinalStage externalId(Optional<String> var1);

        public _FinalStage externalId(String var1);
    }

    public static interface SourceIdStage {
        public _FinalStage sourceId(int var1);
    }

    public static interface UrlStage {
        public SourceIdStage url(@NotNull String var1);
    }

    public static interface HtmlStage {
        public UrlStage html(@NotNull String var1);
    }

    public static interface TitleStage {
        public HtmlStage title(@NotNull String var1);
    }

    public static interface PageIdStage {
        public TitleStage pageId(@NotNull String var1);

        public Builder from(UpdateExternalPageRequest var1);
    }
}

