/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.aicontent.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ExternalPage {
    private final String id;
    private final String title;
    private final String html;
    private final Optional<String> url;
    private final boolean aiAgentAvailability;
    private final boolean aiCopilotAvailability;
    private final Optional<Boolean> finAvailability;
    private final int sourceId;
    private final String externalId;
    private final int createdAt;
    private final int updatedAt;
    private final int lastIngestedAt;
    private final Map<String, Object> additionalProperties;

    private ExternalPage(String id, String title, String html, Optional<String> url, boolean aiAgentAvailability, boolean aiCopilotAvailability, Optional<Boolean> finAvailability, int sourceId, String externalId, int createdAt, int updatedAt, int lastIngestedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.title = title;
        this.html = html;
        this.url = url;
        this.aiAgentAvailability = aiAgentAvailability;
        this.aiCopilotAvailability = aiCopilotAvailability;
        this.finAvailability = finAvailability;
        this.sourceId = sourceId;
        this.externalId = externalId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.lastIngestedAt = lastIngestedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "external_page";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="html")
    public String getHtml() {
        return this.html;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="ai_agent_availability")
    public boolean getAiAgentAvailability() {
        return this.aiAgentAvailability;
    }

    @JsonProperty(value="ai_copilot_availability")
    public boolean getAiCopilotAvailability() {
        return this.aiCopilotAvailability;
    }

    @JsonProperty(value="fin_availability")
    public Optional<Boolean> getFinAvailability() {
        return this.finAvailability;
    }

    @JsonProperty(value="locale")
    public String getLocale() {
        return "en";
    }

    @JsonProperty(value="source_id")
    public int getSourceId() {
        return this.sourceId;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public int getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="last_ingested_at")
    public int getLastIngestedAt() {
        return this.lastIngestedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExternalPage && this.equalTo((ExternalPage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExternalPage other) {
        return this.id.equals(other.id) && this.title.equals(other.title) && this.html.equals(other.html) && this.url.equals(other.url) && this.aiAgentAvailability == other.aiAgentAvailability && this.aiCopilotAvailability == other.aiCopilotAvailability && this.finAvailability.equals(other.finAvailability) && this.sourceId == other.sourceId && this.externalId.equals(other.externalId) && this.createdAt == other.createdAt && this.updatedAt == other.updatedAt && this.lastIngestedAt == other.lastIngestedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.html, this.url, this.aiAgentAvailability, this.aiCopilotAvailability, this.finAvailability, this.sourceId, this.externalId, this.createdAt, this.updatedAt, this.lastIngestedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TitleStage,
    HtmlStage,
    AiAgentAvailabilityStage,
    AiCopilotAvailabilityStage,
    SourceIdStage,
    ExternalIdStage,
    CreatedAtStage,
    UpdatedAtStage,
    LastIngestedAtStage,
    _FinalStage {
        private String id;
        private String title;
        private String html;
        private boolean aiAgentAvailability;
        private boolean aiCopilotAvailability;
        private int sourceId;
        private String externalId;
        private int createdAt;
        private int updatedAt;
        private int lastIngestedAt;
        private Optional<Boolean> finAvailability = Optional.empty();
        private Optional<String> url = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ExternalPage other) {
            this.id(other.getId());
            this.title(other.getTitle());
            this.html(other.getHtml());
            this.url(other.getUrl());
            this.aiAgentAvailability(other.getAiAgentAvailability());
            this.aiCopilotAvailability(other.getAiCopilotAvailability());
            this.finAvailability(other.getFinAvailability());
            this.sourceId(other.getSourceId());
            this.externalId(other.getExternalId());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.lastIngestedAt(other.getLastIngestedAt());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TitleStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public HtmlStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="html")
        public AiAgentAvailabilityStage html(@NotNull String html) {
            this.html = Objects.requireNonNull(html, "html must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="ai_agent_availability")
        public AiCopilotAvailabilityStage aiAgentAvailability(boolean aiAgentAvailability) {
            this.aiAgentAvailability = aiAgentAvailability;
            return this;
        }

        @Override
        @JsonSetter(value="ai_copilot_availability")
        public SourceIdStage aiCopilotAvailability(boolean aiCopilotAvailability) {
            this.aiCopilotAvailability = aiCopilotAvailability;
            return this;
        }

        @Override
        @JsonSetter(value="source_id")
        public ExternalIdStage sourceId(int sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public CreatedAtStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public LastIngestedAtStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        @JsonSetter(value="last_ingested_at")
        public _FinalStage lastIngestedAt(int lastIngestedAt) {
            this.lastIngestedAt = lastIngestedAt;
            return this;
        }

        @Override
        public _FinalStage finAvailability(Boolean finAvailability) {
            this.finAvailability = Optional.ofNullable(finAvailability);
            return this;
        }

        @Override
        @JsonSetter(value="fin_availability", nulls=Nulls.SKIP)
        public _FinalStage finAvailability(Optional<Boolean> finAvailability) {
            this.finAvailability = finAvailability;
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public ExternalPage build() {
            return new ExternalPage(this.id, this.title, this.html, this.url, this.aiAgentAvailability, this.aiCopilotAvailability, this.finAvailability, this.sourceId, this.externalId, this.createdAt, this.updatedAt, this.lastIngestedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ExternalPage build();

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);

        public _FinalStage finAvailability(Optional<Boolean> var1);

        public _FinalStage finAvailability(Boolean var1);
    }

    public static interface LastIngestedAtStage {
        public _FinalStage lastIngestedAt(int var1);
    }

    public static interface UpdatedAtStage {
        public LastIngestedAtStage updatedAt(int var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(int var1);
    }

    public static interface ExternalIdStage {
        public CreatedAtStage externalId(@NotNull String var1);
    }

    public static interface SourceIdStage {
        public ExternalIdStage sourceId(int var1);
    }

    public static interface AiCopilotAvailabilityStage {
        public SourceIdStage aiCopilotAvailability(boolean var1);
    }

    public static interface AiAgentAvailabilityStage {
        public AiCopilotAvailabilityStage aiAgentAvailability(boolean var1);
    }

    public static interface HtmlStage {
        public AiAgentAvailabilityStage html(@NotNull String var1);
    }

    public static interface TitleStage {
        public HtmlStage title(@NotNull String var1);
    }

    public static interface IdStage {
        public TitleStage id(@NotNull String var1);

        public Builder from(ExternalPage var1);
    }
}

