/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.aicontentsource.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContentSource {
    private final Optional<String> contentType;
    private final Optional<String> url;
    private final Optional<String> title;
    private final Optional<String> locale;
    private final Map<String, Object> additionalProperties;

    private ContentSource(Optional<String> contentType, Optional<String> url, Optional<String> title, Optional<String> locale, Map<String, Object> additionalProperties) {
        this.contentType = contentType;
        this.url = url;
        this.title = title;
        this.locale = locale;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="content_type")
    public Optional<String> getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    @JsonProperty(value="locale")
    public Optional<String> getLocale() {
        return this.locale;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContentSource && this.equalTo((ContentSource)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSource other) {
        return this.contentType.equals(other.contentType) && this.url.equals(other.url) && this.title.equals(other.title) && this.locale.equals(other.locale);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.url, this.title, this.locale);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> contentType = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<String> locale = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContentSource other) {
            this.contentType(other.getContentType());
            this.url(other.getUrl());
            this.title(other.getTitle());
            this.locale(other.getLocale());
            return this;
        }

        @JsonSetter(value="content_type", nulls=Nulls.SKIP)
        public Builder contentType(Optional<String> contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = Optional.ofNullable(contentType);
            return this;
        }

        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        @JsonSetter(value="locale", nulls=Nulls.SKIP)
        public Builder locale(Optional<String> locale) {
            this.locale = locale;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = Optional.ofNullable(locale);
            return this;
        }

        public ContentSource build() {
            return new ContentSource(this.contentType, this.url, this.title, this.locale, this.additionalProperties);
        }
    }
}

