/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.calls;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.calls.AsyncRawCallsClient;
import com.intercom.api.resources.calls.requests.ListCallsRequest;
import com.intercom.api.resources.calls.requests.ListCallsWithTranscriptsRequest;
import com.intercom.api.resources.calls.requests.ShowCallRecordingRequest;
import com.intercom.api.resources.calls.requests.ShowCallRequest;
import com.intercom.api.resources.calls.requests.ShowCallTranscriptRequest;
import com.intercom.api.resources.calls.types.Call;
import com.intercom.api.resources.calls.types.ListCallsWithTranscriptsResponse;
import com.intercom.api.types.CallList;
import java.util.concurrent.CompletableFuture;

public class AsyncCallsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCallsClient rawClient;

    public AsyncCallsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCallsClient(clientOptions);
    }

    public AsyncRawCallsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CallList> listCalls() {
        return this.rawClient.listCalls().thenApply(response -> (CallList)response.body());
    }

    public CompletableFuture<CallList> listCalls(ListCallsRequest request) {
        return this.rawClient.listCalls(request).thenApply(response -> (CallList)response.body());
    }

    public CompletableFuture<CallList> listCalls(ListCallsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCalls(request, requestOptions).thenApply(response -> (CallList)response.body());
    }

    public CompletableFuture<Call> showCall(ShowCallRequest request) {
        return this.rawClient.showCall(request).thenApply(response -> (Call)response.body());
    }

    public CompletableFuture<Call> showCall(ShowCallRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCall(request, requestOptions).thenApply(response -> (Call)response.body());
    }

    public CompletableFuture<Void> showCallRecording(ShowCallRecordingRequest request) {
        return this.rawClient.showCallRecording(request).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> showCallRecording(ShowCallRecordingRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCallRecording(request, requestOptions).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<String> showCallTranscript(ShowCallTranscriptRequest request) {
        return this.rawClient.showCallTranscript(request).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<String> showCallTranscript(ShowCallTranscriptRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCallTranscript(request, requestOptions).thenApply(response -> (String)response.body());
    }

    public CompletableFuture<ListCallsWithTranscriptsResponse> listCallsWithTranscripts(ListCallsWithTranscriptsRequest request) {
        return this.rawClient.listCallsWithTranscripts(request).thenApply(response -> (ListCallsWithTranscriptsResponse)response.body());
    }

    public CompletableFuture<ListCallsWithTranscriptsResponse> listCallsWithTranscripts(ListCallsWithTranscriptsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCallsWithTranscripts(request, requestOptions).thenApply(response -> (ListCallsWithTranscriptsResponse)response.body());
    }
}

