/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.UpdateCompanyRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateCompanyRequest {
    private final String companyId;
    private final Optional<UpdateCompanyRequestBody> body;
    private final Map<String, Object> additionalProperties;

    private UpdateCompanyRequest(String companyId, Optional<UpdateCompanyRequestBody> body, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="body")
    public Optional<UpdateCompanyRequestBody> getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateCompanyRequest && this.equalTo((UpdateCompanyRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateCompanyRequest other) {
        return this.companyId.equals(other.companyId) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompanyIdStage,
    _FinalStage {
        private String companyId;
        private Optional<UpdateCompanyRequestBody> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateCompanyRequest other) {
            this.companyId(other.getCompanyId());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public _FinalStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        public _FinalStage body(UpdateCompanyRequestBody body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<UpdateCompanyRequestBody> body) {
            this.body = body;
            return this;
        }

        @Override
        public UpdateCompanyRequest build() {
            return new UpdateCompanyRequest(this.companyId, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateCompanyRequest build();

        public _FinalStage body(Optional<UpdateCompanyRequestBody> var1);

        public _FinalStage body(UpdateCompanyRequestBody var1);
    }

    public static interface CompanyIdStage {
        public _FinalStage companyId(@NotNull String var1);

        public Builder from(UpdateCompanyRequest var1);
    }
}

