/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AttachSubscriptionToContactRequest {
    private final String contactId;
    private final String subscriptionId;
    private final String consentType;
    private final Map<String, Object> additionalProperties;

    private AttachSubscriptionToContactRequest(String contactId, String subscriptionId, String consentType, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.subscriptionId = subscriptionId;
        this.consentType = consentType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="contact_id")
    public String getContactId() {
        return this.contactId;
    }

    @JsonProperty(value="id")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonProperty(value="consent_type")
    public String getConsentType() {
        return this.consentType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AttachSubscriptionToContactRequest && this.equalTo((AttachSubscriptionToContactRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AttachSubscriptionToContactRequest other) {
        return this.contactId.equals(other.contactId) && this.subscriptionId.equals(other.subscriptionId) && this.consentType.equals(other.consentType);
    }

    public int hashCode() {
        return Objects.hash(this.contactId, this.subscriptionId, this.consentType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ContactIdStage,
    SubscriptionIdStage,
    ConsentTypeStage,
    _FinalStage {
        private String contactId;
        private String subscriptionId;
        private String consentType;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AttachSubscriptionToContactRequest other) {
            this.contactId(other.getContactId());
            this.subscriptionId(other.getSubscriptionId());
            this.consentType(other.getConsentType());
            return this;
        }

        @Override
        @JsonSetter(value="contact_id")
        public SubscriptionIdStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ConsentTypeStage subscriptionId(@NotNull String subscriptionId) {
            this.subscriptionId = Objects.requireNonNull(subscriptionId, "subscriptionId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="consent_type")
        public _FinalStage consentType(@NotNull String consentType) {
            this.consentType = Objects.requireNonNull(consentType, "consentType must not be null");
            return this;
        }

        @Override
        public AttachSubscriptionToContactRequest build() {
            return new AttachSubscriptionToContactRequest(this.contactId, this.subscriptionId, this.consentType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AttachSubscriptionToContactRequest build();
    }

    public static interface ConsentTypeStage {
        public _FinalStage consentType(@NotNull String var1);
    }

    public static interface SubscriptionIdStage {
        public ConsentTypeStage subscriptionId(@NotNull String var1);
    }

    public static interface ContactIdStage {
        public SubscriptionIdStage contactId(@NotNull String var1);

        public Builder from(AttachSubscriptionToContactRequest var1);
    }
}

