/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MergeContactsRequest {
    private final Optional<String> leadId;
    private final Optional<String> contactId;
    private final Map<String, Object> additionalProperties;

    private MergeContactsRequest(Optional<String> leadId, Optional<String> contactId, Map<String, Object> additionalProperties) {
        this.leadId = leadId;
        this.contactId = contactId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="from")
    public Optional<String> getLeadId() {
        return this.leadId;
    }

    @JsonProperty(value="into")
    public Optional<String> getContactId() {
        return this.contactId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MergeContactsRequest && this.equalTo((MergeContactsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MergeContactsRequest other) {
        return this.leadId.equals(other.leadId) && this.contactId.equals(other.contactId);
    }

    public int hashCode() {
        return Objects.hash(this.leadId, this.contactId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> leadId = Optional.empty();
        private Optional<String> contactId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(MergeContactsRequest other) {
            this.leadId(other.getLeadId());
            this.contactId(other.getContactId());
            return this;
        }

        @JsonSetter(value="from", nulls=Nulls.SKIP)
        public Builder leadId(Optional<String> leadId) {
            this.leadId = leadId;
            return this;
        }

        public Builder leadId(String leadId) {
            this.leadId = Optional.ofNullable(leadId);
            return this;
        }

        @JsonSetter(value="into", nulls=Nulls.SKIP)
        public Builder contactId(Optional<String> contactId) {
            this.contactId = contactId;
            return this;
        }

        public Builder contactId(String contactId) {
            this.contactId = Optional.ofNullable(contactId);
            return this;
        }

        public MergeContactsRequest build() {
            return new MergeContactsRequest(this.leadId, this.contactId, this.additionalProperties);
        }
    }
}

