/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.conversations;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.conversations.AsyncRawConversationsClient;
import com.intercom.api.resources.conversations.requests.AttachContactToConversationRequest;
import com.intercom.api.resources.conversations.requests.AutoAssignConversationRequest;
import com.intercom.api.resources.conversations.requests.ConvertConversationToTicketRequest;
import com.intercom.api.resources.conversations.requests.CreateConversationRequest;
import com.intercom.api.resources.conversations.requests.DeleteConversationRequest;
import com.intercom.api.resources.conversations.requests.DetachContactFromConversationRequest;
import com.intercom.api.resources.conversations.requests.FindConversationRequest;
import com.intercom.api.resources.conversations.requests.ListConversationsRequest;
import com.intercom.api.resources.conversations.requests.ManageConversationPartsRequest;
import com.intercom.api.resources.conversations.requests.ReplyToConversationRequest;
import com.intercom.api.resources.conversations.requests.UpdateConversationRequest;
import com.intercom.api.resources.conversations.types.Conversation;
import com.intercom.api.resources.messages.types.Message;
import com.intercom.api.resources.tickets.types.Ticket;
import com.intercom.api.types.ConversationDeleted;
import com.intercom.api.types.RedactConversationRequest;
import com.intercom.api.types.SearchRequest;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncConversationsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawConversationsClient rawClient;

    public AsyncConversationsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawConversationsClient(clientOptions);
    }

    public AsyncRawConversationsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Conversation>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Conversation>> list(ListConversationsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Conversation>> list(ListConversationsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<Message> create(CreateConversationRequest request) {
        return this.rawClient.create(request).thenApply(response -> (Message)response.body());
    }

    public CompletableFuture<Message> create(CreateConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (Message)response.body());
    }

    public CompletableFuture<Conversation> find(FindConversationRequest request) {
        return this.rawClient.find(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> find(FindConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> update(UpdateConversationRequest request) {
        return this.rawClient.update(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> update(UpdateConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<ConversationDeleted> deleteConversation(DeleteConversationRequest request) {
        return this.rawClient.deleteConversation(request).thenApply(response -> (ConversationDeleted)response.body());
    }

    public CompletableFuture<ConversationDeleted> deleteConversation(DeleteConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteConversation(request, requestOptions).thenApply(response -> (ConversationDeleted)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Conversation>> search(SearchRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Conversation>> search(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<Conversation> reply(ReplyToConversationRequest request) {
        return this.rawClient.reply(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> reply(ReplyToConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.reply(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> manage(ManageConversationPartsRequest request) {
        return this.rawClient.manage(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> manage(ManageConversationPartsRequest request, RequestOptions requestOptions) {
        return this.rawClient.manage(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> attachContactAsAdmin(AttachContactToConversationRequest request) {
        return this.rawClient.attachContactAsAdmin(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> attachContactAsAdmin(AttachContactToConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachContactAsAdmin(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> detachContactAsAdmin(DetachContactFromConversationRequest request) {
        return this.rawClient.detachContactAsAdmin(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> detachContactAsAdmin(DetachContactFromConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachContactAsAdmin(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> redactConversationPart(RedactConversationRequest request) {
        return this.rawClient.redactConversationPart(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> redactConversationPart(RedactConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.redactConversationPart(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Optional<Ticket>> convertToTicket(ConvertConversationToTicketRequest request) {
        return this.rawClient.convertToTicket(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<Ticket>> convertToTicket(ConvertConversationToTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.convertToTicket(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Conversation> runAssignmentRules(AutoAssignConversationRequest request) {
        return this.rawClient.runAssignmentRules(request).thenApply(response -> (Conversation)response.body());
    }

    public CompletableFuture<Conversation> runAssignmentRules(AutoAssignConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.runAssignmentRules(request, requestOptions).thenApply(response -> (Conversation)response.body());
    }
}

