/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DetachContactFromConversationRequest {
    private final String conversationId;
    private final String contactId;
    private final String adminId;
    private final Map<String, Object> additionalProperties;

    private DetachContactFromConversationRequest(String conversationId, String contactId, String adminId, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.contactId = contactId;
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="conversation_id")
    public String getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="contact_id")
    public String getContactId() {
        return this.contactId;
    }

    @JsonProperty(value="admin_id")
    public String getAdminId() {
        return this.adminId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DetachContactFromConversationRequest && this.equalTo((DetachContactFromConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DetachContactFromConversationRequest other) {
        return this.conversationId.equals(other.conversationId) && this.contactId.equals(other.contactId) && this.adminId.equals(other.adminId);
    }

    public int hashCode() {
        return Objects.hash(this.conversationId, this.contactId, this.adminId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConversationIdStage,
    ContactIdStage,
    AdminIdStage,
    _FinalStage {
        private String conversationId;
        private String contactId;
        private String adminId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DetachContactFromConversationRequest other) {
            this.conversationId(other.getConversationId());
            this.contactId(other.getContactId());
            this.adminId(other.getAdminId());
            return this;
        }

        @Override
        @JsonSetter(value="conversation_id")
        public ContactIdStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="contact_id")
        public AdminIdStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="admin_id")
        public _FinalStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        @Override
        public DetachContactFromConversationRequest build() {
            return new DetachContactFromConversationRequest(this.conversationId, this.contactId, this.adminId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DetachContactFromConversationRequest build();
    }

    public static interface AdminIdStage {
        public _FinalStage adminId(@NotNull String var1);
    }

    public static interface ContactIdStage {
        public AdminIdStage contactId(@NotNull String var1);
    }

    public static interface ConversationIdStage {
        public ContactIdStage conversationId(@NotNull String var1);

        public Builder from(DetachContactFromConversationRequest var1);
    }
}

