/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.customobjectinstances.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetCustomObjectInstancesByExternalIdRequest {
    private final String customObjectTypeIdentifier;
    private final String externalId;
    private final Map<String, Object> additionalProperties;

    private GetCustomObjectInstancesByExternalIdRequest(String customObjectTypeIdentifier, String externalId, Map<String, Object> additionalProperties) {
        this.customObjectTypeIdentifier = customObjectTypeIdentifier;
        this.externalId = externalId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="custom_object_type_identifier")
    public String getCustomObjectTypeIdentifier() {
        return this.customObjectTypeIdentifier;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetCustomObjectInstancesByExternalIdRequest && this.equalTo((GetCustomObjectInstancesByExternalIdRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetCustomObjectInstancesByExternalIdRequest other) {
        return this.customObjectTypeIdentifier.equals(other.customObjectTypeIdentifier) && this.externalId.equals(other.externalId);
    }

    public int hashCode() {
        return Objects.hash(this.customObjectTypeIdentifier, this.externalId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomObjectTypeIdentifierStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomObjectTypeIdentifierStage,
    ExternalIdStage,
    _FinalStage {
        private String customObjectTypeIdentifier;
        private String externalId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetCustomObjectInstancesByExternalIdRequest other) {
            this.customObjectTypeIdentifier(other.getCustomObjectTypeIdentifier());
            this.externalId(other.getExternalId());
            return this;
        }

        @Override
        @JsonSetter(value="custom_object_type_identifier")
        public ExternalIdStage customObjectTypeIdentifier(@NotNull String customObjectTypeIdentifier) {
            this.customObjectTypeIdentifier = Objects.requireNonNull(customObjectTypeIdentifier, "customObjectTypeIdentifier must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public _FinalStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        public GetCustomObjectInstancesByExternalIdRequest build() {
            return new GetCustomObjectInstancesByExternalIdRequest(this.customObjectTypeIdentifier, this.externalId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetCustomObjectInstancesByExternalIdRequest build();
    }

    public static interface ExternalIdStage {
        public _FinalStage externalId(@NotNull String var1);
    }

    public static interface CustomObjectTypeIdentifierStage {
        public ExternalIdStage customObjectTypeIdentifier(@NotNull String var1);

        public Builder from(GetCustomObjectInstancesByExternalIdRequest var1);
    }
}

