/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.customobjectinstances.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetCustomObjectInstancesByIdRequest {
    private final String customObjectTypeIdentifier;
    private final String customObjectInstanceId;
    private final Map<String, Object> additionalProperties;

    private GetCustomObjectInstancesByIdRequest(String customObjectTypeIdentifier, String customObjectInstanceId, Map<String, Object> additionalProperties) {
        this.customObjectTypeIdentifier = customObjectTypeIdentifier;
        this.customObjectInstanceId = customObjectInstanceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="custom_object_type_identifier")
    public String getCustomObjectTypeIdentifier() {
        return this.customObjectTypeIdentifier;
    }

    @JsonProperty(value="custom_object_instance_id")
    public String getCustomObjectInstanceId() {
        return this.customObjectInstanceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetCustomObjectInstancesByIdRequest && this.equalTo((GetCustomObjectInstancesByIdRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetCustomObjectInstancesByIdRequest other) {
        return this.customObjectTypeIdentifier.equals(other.customObjectTypeIdentifier) && this.customObjectInstanceId.equals(other.customObjectInstanceId);
    }

    public int hashCode() {
        return Objects.hash(this.customObjectTypeIdentifier, this.customObjectInstanceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomObjectTypeIdentifierStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomObjectTypeIdentifierStage,
    CustomObjectInstanceIdStage,
    _FinalStage {
        private String customObjectTypeIdentifier;
        private String customObjectInstanceId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetCustomObjectInstancesByIdRequest other) {
            this.customObjectTypeIdentifier(other.getCustomObjectTypeIdentifier());
            this.customObjectInstanceId(other.getCustomObjectInstanceId());
            return this;
        }

        @Override
        @JsonSetter(value="custom_object_type_identifier")
        public CustomObjectInstanceIdStage customObjectTypeIdentifier(@NotNull String customObjectTypeIdentifier) {
            this.customObjectTypeIdentifier = Objects.requireNonNull(customObjectTypeIdentifier, "customObjectTypeIdentifier must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="custom_object_instance_id")
        public _FinalStage customObjectInstanceId(@NotNull String customObjectInstanceId) {
            this.customObjectInstanceId = Objects.requireNonNull(customObjectInstanceId, "customObjectInstanceId must not be null");
            return this;
        }

        @Override
        public GetCustomObjectInstancesByIdRequest build() {
            return new GetCustomObjectInstancesByIdRequest(this.customObjectTypeIdentifier, this.customObjectInstanceId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetCustomObjectInstancesByIdRequest build();
    }

    public static interface CustomObjectInstanceIdStage {
        public _FinalStage customObjectInstanceId(@NotNull String var1);
    }

    public static interface CustomObjectTypeIdentifierStage {
        public CustomObjectInstanceIdStage customObjectTypeIdentifier(@NotNull String var1);

        public Builder from(GetCustomObjectInstancesByIdRequest var1);
    }
}

