/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.dataattributes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.dataattributes.AsyncRawDataAttributesClient;
import com.intercom.api.resources.dataattributes.requests.ListDataAttributesRequest;
import com.intercom.api.resources.dataattributes.requests.UpdateDataAttributeRequest;
import com.intercom.api.resources.dataattributes.types.DataAttribute;
import com.intercom.api.types.CreateDataAttributeRequest;
import com.intercom.api.types.DataAttributeList;
import java.util.concurrent.CompletableFuture;

public class AsyncDataAttributesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawDataAttributesClient rawClient;

    public AsyncDataAttributesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDataAttributesClient(clientOptions);
    }

    public AsyncRawDataAttributesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<DataAttributeList> list() {
        return this.rawClient.list().thenApply(response -> (DataAttributeList)response.body());
    }

    public CompletableFuture<DataAttributeList> list(ListDataAttributesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (DataAttributeList)response.body());
    }

    public CompletableFuture<DataAttributeList> list(ListDataAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (DataAttributeList)response.body());
    }

    public CompletableFuture<DataAttribute> create(CreateDataAttributeRequest request) {
        return this.rawClient.create(request).thenApply(response -> (DataAttribute)response.body());
    }

    public CompletableFuture<DataAttribute> create(CreateDataAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (DataAttribute)response.body());
    }

    public CompletableFuture<DataAttribute> update(UpdateDataAttributeRequest request) {
        return this.rawClient.update(request).thenApply(response -> (DataAttribute)response.body());
    }

    public CompletableFuture<DataAttribute> update(UpdateDataAttributeRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (DataAttribute)response.body());
    }
}

