/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.dataevents.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DataEvent {
    private final Optional<String> type;
    private final String eventName;
    private final int createdAt;
    private final Optional<String> userId;
    private final Optional<String> id;
    private final Optional<String> intercomUserId;
    private final Optional<String> email;
    private final Optional<Map<String, String>> metadata;
    private final Map<String, Object> additionalProperties;

    private DataEvent(Optional<String> type, String eventName, int createdAt, Optional<String> userId, Optional<String> id, Optional<String> intercomUserId, Optional<String> email, Optional<Map<String, String>> metadata, Map<String, Object> additionalProperties) {
        this.type = type;
        this.eventName = eventName;
        this.createdAt = createdAt;
        this.userId = userId;
        this.id = id;
        this.intercomUserId = intercomUserId;
        this.email = email;
        this.metadata = metadata;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="event_name")
    public String getEventName() {
        return this.eventName;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="intercom_user_id")
    public Optional<String> getIntercomUserId() {
        return this.intercomUserId;
    }

    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    @JsonProperty(value="metadata")
    public Optional<Map<String, String>> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataEvent && this.equalTo((DataEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataEvent other) {
        return this.type.equals(other.type) && this.eventName.equals(other.eventName) && this.createdAt == other.createdAt && this.userId.equals(other.userId) && this.id.equals(other.id) && this.intercomUserId.equals(other.intercomUserId) && this.email.equals(other.email) && this.metadata.equals(other.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.eventName, this.createdAt, this.userId, this.id, this.intercomUserId, this.email, this.metadata);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EventNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EventNameStage,
    CreatedAtStage,
    _FinalStage {
        private String eventName;
        private int createdAt;
        private Optional<Map<String, String>> metadata = Optional.empty();
        private Optional<String> email = Optional.empty();
        private Optional<String> intercomUserId = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> userId = Optional.empty();
        private Optional<String> type = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DataEvent other) {
            this.type(other.getType());
            this.eventName(other.getEventName());
            this.createdAt(other.getCreatedAt());
            this.userId(other.getUserId());
            this.id(other.getId());
            this.intercomUserId(other.getIntercomUserId());
            this.email(other.getEmail());
            this.metadata(other.getMetadata());
            return this;
        }

        @Override
        @JsonSetter(value="event_name")
        public CreatedAtStage eventName(@NotNull String eventName) {
            this.eventName = Objects.requireNonNull(eventName, "eventName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage metadata(Map<String, String> metadata) {
            this.metadata = Optional.ofNullable(metadata);
            return this;
        }

        @Override
        @JsonSetter(value="metadata", nulls=Nulls.SKIP)
        public _FinalStage metadata(Optional<Map<String, String>> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @Override
        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        @Override
        public _FinalStage intercomUserId(String intercomUserId) {
            this.intercomUserId = Optional.ofNullable(intercomUserId);
            return this;
        }

        @Override
        @JsonSetter(value="intercom_user_id", nulls=Nulls.SKIP)
        public _FinalStage intercomUserId(Optional<String> intercomUserId) {
            this.intercomUserId = intercomUserId;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @Override
        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public _FinalStage type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @Override
        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public _FinalStage type(Optional<String> type) {
            this.type = type;
            return this;
        }

        @Override
        public DataEvent build() {
            return new DataEvent(this.type, this.eventName, this.createdAt, this.userId, this.id, this.intercomUserId, this.email, this.metadata, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DataEvent build();

        public _FinalStage type(Optional<String> var1);

        public _FinalStage type(String var1);

        public _FinalStage userId(Optional<String> var1);

        public _FinalStage userId(String var1);

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage intercomUserId(Optional<String> var1);

        public _FinalStage intercomUserId(String var1);

        public _FinalStage email(Optional<String> var1);

        public _FinalStage email(String var1);

        public _FinalStage metadata(Optional<Map<String, String>> var1);

        public _FinalStage metadata(Map<String, String> var1);
    }

    public static interface CreatedAtStage {
        public _FinalStage createdAt(int var1);
    }

    public static interface EventNameStage {
        public CreatedAtStage eventName(@NotNull String var1);

        public Builder from(DataEvent var1);
    }
}

