/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.events;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.events.AsyncRawEventsClient;
import com.intercom.api.resources.events.requests.ListEventSummariesRequest;
import com.intercom.api.resources.events.requests.ListEventsRequest;
import com.intercom.api.types.CreateDataEventRequest;
import com.intercom.api.types.DataEventSummary;
import java.util.concurrent.CompletableFuture;

public class AsyncEventsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawEventsClient rawClient;

    public AsyncEventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawEventsClient(clientOptions);
    }

    public AsyncRawEventsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<DataEventSummary> list(ListEventsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (DataEventSummary)response.body());
    }

    public CompletableFuture<DataEventSummary> list(ListEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (DataEventSummary)response.body());
    }

    public CompletableFuture<Void> create(CreateDataEventRequest request) {
        return this.rawClient.create(request).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> create(CreateDataEventRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> summaries() {
        return this.rawClient.summaries().thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> summaries(ListEventSummariesRequest request) {
        return this.rawClient.summaries(request).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> summaries(ListEventSummariesRequest request, RequestOptions requestOptions) {
        return this.rawClient.summaries(request, requestOptions).thenApply(response -> (Void)response.body());
    }
}

