/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.helpcenters;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.Suppliers;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.helpcenter.types.HelpCenter;
import com.intercom.api.resources.helpcenters.AsyncRawHelpCentersClient;
import com.intercom.api.resources.helpcenters.collections.AsyncCollectionsClient;
import com.intercom.api.resources.helpcenters.requests.FindHelpCenterRequest;
import com.intercom.api.resources.helpcenters.requests.ListHelpCentersRequest;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncHelpCentersClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawHelpCentersClient rawClient;
    protected final Supplier<AsyncCollectionsClient> collectionsClient;

    public AsyncHelpCentersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawHelpCentersClient(clientOptions);
        this.collectionsClient = Suppliers.memoize(() -> new AsyncCollectionsClient(clientOptions));
    }

    public AsyncRawHelpCentersClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<HelpCenter> find(FindHelpCenterRequest request) {
        return this.rawClient.find(request).thenApply(response -> (HelpCenter)response.body());
    }

    public CompletableFuture<HelpCenter> find(FindHelpCenterRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (HelpCenter)response.body());
    }

    public CompletableFuture<SyncPagingIterable<HelpCenter>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<HelpCenter>> list(ListHelpCentersRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<HelpCenter>> list(ListHelpCentersRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public AsyncCollectionsClient collections() {
        return this.collectionsClient.get();
    }
}

