/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.helpcenters;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.Suppliers;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.helpcenter.types.HelpCenter;
import com.intercom.api.resources.helpcenters.RawHelpCentersClient;
import com.intercom.api.resources.helpcenters.collections.CollectionsClient;
import com.intercom.api.resources.helpcenters.requests.FindHelpCenterRequest;
import com.intercom.api.resources.helpcenters.requests.ListHelpCentersRequest;
import java.util.function.Supplier;

public class HelpCentersClient {
    protected final ClientOptions clientOptions;
    private final RawHelpCentersClient rawClient;
    protected final Supplier<CollectionsClient> collectionsClient;

    public HelpCentersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawHelpCentersClient(clientOptions);
        this.collectionsClient = Suppliers.memoize(() -> new CollectionsClient(clientOptions));
    }

    public RawHelpCentersClient withRawResponse() {
        return this.rawClient;
    }

    public HelpCenter find(FindHelpCenterRequest request) {
        return this.rawClient.find(request).body();
    }

    public HelpCenter find(FindHelpCenterRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    public SyncPagingIterable<HelpCenter> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<HelpCenter> list(ListHelpCentersRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<HelpCenter> list(ListHelpCentersRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public CollectionsClient collections() {
        return this.collectionsClient.get();
    }
}

