/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.helpcenters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.QueryStringMapper;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.errors.NotFoundError;
import com.intercom.api.errors.UnauthorizedError;
import com.intercom.api.resources.helpcenter.types.HelpCenter;
import com.intercom.api.resources.helpcenter.types.HelpCenterList;
import com.intercom.api.resources.helpcenters.requests.FindHelpCenterRequest;
import com.intercom.api.resources.helpcenters.requests.ListHelpCentersRequest;
import com.intercom.api.types.Error;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawHelpCentersClient {
    protected final ClientOptions clientOptions;

    public RawHelpCentersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public IntercomHttpResponse<HelpCenter> find(FindHelpCenterRequest request) {
        return this.find(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<HelpCenter> find(FindHelpCenterRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("help_center/help_centers").addPathSegment(Integer.toString(request.getHelpCenterId())).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                IntercomHttpResponse<HelpCenter> intercomHttpResponse = new IntercomHttpResponse<HelpCenter>((HelpCenter)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HelpCenter.class), response);
                return intercomHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<SyncPagingIterable<HelpCenter>> list() {
        return this.list(ListHelpCentersRequest.builder().build());
    }

    public IntercomHttpResponse<SyncPagingIterable<HelpCenter>> list(ListHelpCentersRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<SyncPagingIterable<HelpCenter>> list(ListHelpCentersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("help_center/help_centers");
        if (request.getPage().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "page", request.getPage().get(), false);
        }
        if (request.getPerPage().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "per_page", request.getPerPage().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                HelpCenterList parsedResponse = (HelpCenterList)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, HelpCenterList.class);
                int newPageNumber = request.getPage().map(page -> page + 1).orElse(1);
                ListHelpCentersRequest nextRequest = ListHelpCentersRequest.builder().from(request).page(newPageNumber).build();
                List result = parsedResponse.getData().orElse(Collections.emptyList());
                IntercomHttpResponse<SyncPagingIterable<HelpCenter>> intercomHttpResponse = new IntercomHttpResponse<SyncPagingIterable<HelpCenter>>(new SyncPagingIterable(true, result, (Object)parsedResponse, () -> this.list(nextRequest, requestOptions).body()), response);
                return intercomHttpResponse;
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            }
            catch (JsonProcessingException parsedResponse) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}

