/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.helpcenters.collections;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.helpcenter.types.Collection;
import com.intercom.api.resources.helpcenters.collections.AsyncRawCollectionsClient;
import com.intercom.api.resources.helpcenters.collections.requests.CreateCollectionRequest;
import com.intercom.api.resources.helpcenters.collections.requests.DeleteCollectionRequest;
import com.intercom.api.resources.helpcenters.collections.requests.FindCollectionRequest;
import com.intercom.api.resources.helpcenters.collections.requests.ListCollectionsRequest;
import com.intercom.api.resources.helpcenters.collections.requests.UpdateCollectionRequest;
import com.intercom.api.types.DeletedCollectionObject;
import java.util.concurrent.CompletableFuture;

public class AsyncCollectionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCollectionsClient rawClient;

    public AsyncCollectionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCollectionsClient(clientOptions);
    }

    public AsyncRawCollectionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Collection>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Collection>> list(ListCollectionsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Collection>> list(ListCollectionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<Collection> create(CreateCollectionRequest request) {
        return this.rawClient.create(request).thenApply(response -> (Collection)response.body());
    }

    public CompletableFuture<Collection> create(CreateCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (Collection)response.body());
    }

    public CompletableFuture<Collection> find(FindCollectionRequest request) {
        return this.rawClient.find(request).thenApply(response -> (Collection)response.body());
    }

    public CompletableFuture<Collection> find(FindCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (Collection)response.body());
    }

    public CompletableFuture<Collection> update(UpdateCollectionRequest request) {
        return this.rawClient.update(request).thenApply(response -> (Collection)response.body());
    }

    public CompletableFuture<Collection> update(UpdateCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (Collection)response.body());
    }

    public CompletableFuture<DeletedCollectionObject> delete(DeleteCollectionRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeletedCollectionObject)response.body());
    }

    public CompletableFuture<DeletedCollectionObject> delete(DeleteCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeletedCollectionObject)response.body());
    }
}

