/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.helpcenters.collections;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.helpcenter.types.Collection;
import com.intercom.api.resources.helpcenters.collections.RawCollectionsClient;
import com.intercom.api.resources.helpcenters.collections.requests.CreateCollectionRequest;
import com.intercom.api.resources.helpcenters.collections.requests.DeleteCollectionRequest;
import com.intercom.api.resources.helpcenters.collections.requests.FindCollectionRequest;
import com.intercom.api.resources.helpcenters.collections.requests.ListCollectionsRequest;
import com.intercom.api.resources.helpcenters.collections.requests.UpdateCollectionRequest;
import com.intercom.api.types.DeletedCollectionObject;

public class CollectionsClient {
    protected final ClientOptions clientOptions;
    private final RawCollectionsClient rawClient;

    public CollectionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCollectionsClient(clientOptions);
    }

    public RawCollectionsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<Collection> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<Collection> list(ListCollectionsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<Collection> list(ListCollectionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public Collection create(CreateCollectionRequest request) {
        return this.rawClient.create(request).body();
    }

    public Collection create(CreateCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public Collection find(FindCollectionRequest request) {
        return this.rawClient.find(request).body();
    }

    public Collection find(FindCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    public Collection update(UpdateCollectionRequest request) {
        return this.rawClient.update(request).body();
    }

    public Collection update(UpdateCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public DeletedCollectionObject delete(DeleteCollectionRequest request) {
        return this.rawClient.delete(request).body();
    }

    public DeletedCollectionObject delete(DeleteCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).body();
    }
}

