/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.helpcenters.collections.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.GroupTranslatedContent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCollectionRequest {
    private final String name;
    private final Optional<String> description;
    private final Optional<GroupTranslatedContent> translatedContent;
    private final Optional<String> parentId;
    private final Optional<Integer> helpCenterId;
    private final Map<String, Object> additionalProperties;

    private CreateCollectionRequest(String name, Optional<String> description, Optional<GroupTranslatedContent> translatedContent, Optional<String> parentId, Optional<Integer> helpCenterId, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.translatedContent = translatedContent;
        this.parentId = parentId;
        this.helpCenterId = helpCenterId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="translated_content")
    public Optional<GroupTranslatedContent> getTranslatedContent() {
        return this.translatedContent;
    }

    @JsonProperty(value="parent_id")
    public Optional<String> getParentId() {
        return this.parentId;
    }

    @JsonProperty(value="help_center_id")
    public Optional<Integer> getHelpCenterId() {
        return this.helpCenterId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCollectionRequest && this.equalTo((CreateCollectionRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCollectionRequest other) {
        return this.name.equals(other.name) && this.description.equals(other.description) && this.translatedContent.equals(other.translatedContent) && this.parentId.equals(other.parentId) && this.helpCenterId.equals(other.helpCenterId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.translatedContent, this.parentId, this.helpCenterId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    _FinalStage {
        private String name;
        private Optional<Integer> helpCenterId = Optional.empty();
        private Optional<String> parentId = Optional.empty();
        private Optional<GroupTranslatedContent> translatedContent = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateCollectionRequest other) {
            this.name(other.getName());
            this.description(other.getDescription());
            this.translatedContent(other.getTranslatedContent());
            this.parentId(other.getParentId());
            this.helpCenterId(other.getHelpCenterId());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage helpCenterId(Integer helpCenterId) {
            this.helpCenterId = Optional.ofNullable(helpCenterId);
            return this;
        }

        @Override
        @JsonSetter(value="help_center_id", nulls=Nulls.SKIP)
        public _FinalStage helpCenterId(Optional<Integer> helpCenterId) {
            this.helpCenterId = helpCenterId;
            return this;
        }

        @Override
        public _FinalStage parentId(String parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        @Override
        @JsonSetter(value="parent_id", nulls=Nulls.SKIP)
        public _FinalStage parentId(Optional<String> parentId) {
            this.parentId = parentId;
            return this;
        }

        @Override
        public _FinalStage translatedContent(GroupTranslatedContent translatedContent) {
            this.translatedContent = Optional.ofNullable(translatedContent);
            return this;
        }

        @Override
        @JsonSetter(value="translated_content", nulls=Nulls.SKIP)
        public _FinalStage translatedContent(Optional<GroupTranslatedContent> translatedContent) {
            this.translatedContent = translatedContent;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public CreateCollectionRequest build() {
            return new CreateCollectionRequest(this.name, this.description, this.translatedContent, this.parentId, this.helpCenterId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateCollectionRequest build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage translatedContent(Optional<GroupTranslatedContent> var1);

        public _FinalStage translatedContent(GroupTranslatedContent var1);

        public _FinalStage parentId(Optional<String> var1);

        public _FinalStage parentId(String var1);

        public _FinalStage helpCenterId(Optional<Integer> var1);

        public _FinalStage helpCenterId(Integer var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);

        public Builder from(CreateCollectionRequest var1);
    }
}

