/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.helpcenters.collections.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.GroupTranslatedContent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateCollectionRequest {
    private final int collectionId;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<GroupTranslatedContent> translatedContent;
    private final Optional<String> parentId;
    private final Map<String, Object> additionalProperties;

    private UpdateCollectionRequest(int collectionId, Optional<String> name, Optional<String> description, Optional<GroupTranslatedContent> translatedContent, Optional<String> parentId, Map<String, Object> additionalProperties) {
        this.collectionId = collectionId;
        this.name = name;
        this.description = description;
        this.translatedContent = translatedContent;
        this.parentId = parentId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="collection_id")
    public int getCollectionId() {
        return this.collectionId;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="translated_content")
    public Optional<GroupTranslatedContent> getTranslatedContent() {
        return this.translatedContent;
    }

    @JsonProperty(value="parent_id")
    public Optional<String> getParentId() {
        return this.parentId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateCollectionRequest && this.equalTo((UpdateCollectionRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateCollectionRequest other) {
        return this.collectionId == other.collectionId && this.name.equals(other.name) && this.description.equals(other.description) && this.translatedContent.equals(other.translatedContent) && this.parentId.equals(other.parentId);
    }

    public int hashCode() {
        return Objects.hash(this.collectionId, this.name, this.description, this.translatedContent, this.parentId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CollectionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CollectionIdStage,
    _FinalStage {
        private int collectionId;
        private Optional<String> parentId = Optional.empty();
        private Optional<GroupTranslatedContent> translatedContent = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateCollectionRequest other) {
            this.collectionId(other.getCollectionId());
            this.name(other.getName());
            this.description(other.getDescription());
            this.translatedContent(other.getTranslatedContent());
            this.parentId(other.getParentId());
            return this;
        }

        @Override
        @JsonSetter(value="collection_id")
        public _FinalStage collectionId(int collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        @Override
        public _FinalStage parentId(String parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        @Override
        @JsonSetter(value="parent_id", nulls=Nulls.SKIP)
        public _FinalStage parentId(Optional<String> parentId) {
            this.parentId = parentId;
            return this;
        }

        @Override
        public _FinalStage translatedContent(GroupTranslatedContent translatedContent) {
            this.translatedContent = Optional.ofNullable(translatedContent);
            return this;
        }

        @Override
        @JsonSetter(value="translated_content", nulls=Nulls.SKIP)
        public _FinalStage translatedContent(Optional<GroupTranslatedContent> translatedContent) {
            this.translatedContent = translatedContent;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public UpdateCollectionRequest build() {
            return new UpdateCollectionRequest(this.collectionId, this.name, this.description, this.translatedContent, this.parentId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateCollectionRequest build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage translatedContent(Optional<GroupTranslatedContent> var1);

        public _FinalStage translatedContent(GroupTranslatedContent var1);

        public _FinalStage parentId(Optional<String> var1);

        public _FinalStage parentId(String var1);
    }

    public static interface CollectionIdStage {
        public _FinalStage collectionId(int var1);

        public Builder from(UpdateCollectionRequest var1);
    }
}

