/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.messages;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.messages.AsyncRawMessagesClient;
import com.intercom.api.resources.messages.types.Message;
import com.intercom.api.types.CreateMessageRequest;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncMessagesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawMessagesClient rawClient;

    public AsyncMessagesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawMessagesClient(clientOptions);
    }

    public AsyncRawMessagesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Message> create() {
        return this.rawClient.create().thenApply(response -> (Message)response.body());
    }

    public CompletableFuture<Message> create(Optional<CreateMessageRequest> request) {
        return this.rawClient.create(request).thenApply(response -> (Message)response.body());
    }

    public CompletableFuture<Message> create(Optional<CreateMessageRequest> request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (Message)response.body());
    }
}

