/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.news.feeds;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.news.feeds.AsyncRawFeedsClient;
import com.intercom.api.resources.news.feeds.requests.FindNewsFeedRequest;
import com.intercom.api.resources.news.feeds.requests.ListNewsFeedItemsRequest;
import com.intercom.api.resources.news.types.Newsfeed;
import com.intercom.api.types.PaginatedResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncFeedsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawFeedsClient rawClient;

    public AsyncFeedsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawFeedsClient(clientOptions);
    }

    public AsyncRawFeedsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<PaginatedResponse> listItems(ListNewsFeedItemsRequest request) {
        return this.rawClient.listItems(request).thenApply(response -> (PaginatedResponse)response.body());
    }

    public CompletableFuture<PaginatedResponse> listItems(ListNewsFeedItemsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listItems(request, requestOptions).thenApply(response -> (PaginatedResponse)response.body());
    }

    public CompletableFuture<PaginatedResponse> list() {
        return this.rawClient.list().thenApply(response -> (PaginatedResponse)response.body());
    }

    public CompletableFuture<PaginatedResponse> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> (PaginatedResponse)response.body());
    }

    public CompletableFuture<Newsfeed> find(FindNewsFeedRequest request) {
        return this.rawClient.find(request).thenApply(response -> (Newsfeed)response.body());
    }

    public CompletableFuture<Newsfeed> find(FindNewsFeedRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (Newsfeed)response.body());
    }
}

