/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.news.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.news.types.NewsfeedAssignment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class NewsItem {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> workspaceId;
    private final Optional<String> title;
    private final Optional<String> body;
    private final Optional<Integer> senderId;
    private final Optional<State> state;
    private final Optional<List<NewsfeedAssignment>> newsfeedAssignments;
    private final Optional<List<Optional<String>>> labels;
    private final Optional<String> coverImageUrl;
    private final Optional<List<Optional<String>>> reactions;
    private final Optional<Boolean> deliverSilently;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> updatedAt;
    private final Map<String, Object> additionalProperties;

    private NewsItem(Optional<String> type, Optional<String> id, Optional<String> workspaceId, Optional<String> title, Optional<String> body, Optional<Integer> senderId, Optional<State> state, Optional<List<NewsfeedAssignment>> newsfeedAssignments, Optional<List<Optional<String>>> labels, Optional<String> coverImageUrl, Optional<List<Optional<String>>> reactions, Optional<Boolean> deliverSilently, Optional<Integer> createdAt, Optional<Integer> updatedAt, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.workspaceId = workspaceId;
        this.title = title;
        this.body = body;
        this.senderId = senderId;
        this.state = state;
        this.newsfeedAssignments = newsfeedAssignments;
        this.labels = labels;
        this.coverImageUrl = coverImageUrl;
        this.reactions = reactions;
        this.deliverSilently = deliverSilently;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="workspace_id")
    public Optional<String> getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="sender_id")
    public Optional<Integer> getSenderId() {
        return this.senderId;
    }

    @JsonProperty(value="state")
    public Optional<State> getState() {
        return this.state;
    }

    @JsonProperty(value="newsfeed_assignments")
    public Optional<List<NewsfeedAssignment>> getNewsfeedAssignments() {
        return this.newsfeedAssignments;
    }

    @JsonProperty(value="labels")
    public Optional<List<Optional<String>>> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="cover_image_url")
    public Optional<String> getCoverImageUrl() {
        return this.coverImageUrl;
    }

    @JsonProperty(value="reactions")
    public Optional<List<Optional<String>>> getReactions() {
        return this.reactions;
    }

    @JsonProperty(value="deliver_silently")
    public Optional<Boolean> getDeliverSilently() {
        return this.deliverSilently;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NewsItem && this.equalTo((NewsItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NewsItem other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.workspaceId.equals(other.workspaceId) && this.title.equals(other.title) && this.body.equals(other.body) && this.senderId.equals(other.senderId) && this.state.equals(other.state) && this.newsfeedAssignments.equals(other.newsfeedAssignments) && this.labels.equals(other.labels) && this.coverImageUrl.equals(other.coverImageUrl) && this.reactions.equals(other.reactions) && this.deliverSilently.equals(other.deliverSilently) && this.createdAt.equals(other.createdAt) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.workspaceId, this.title, this.body, this.senderId, this.state, this.newsfeedAssignments, this.labels, this.coverImageUrl, this.reactions, this.deliverSilently, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class State {
        public static final State LIVE = new State(Value.LIVE, "live");
        public static final State DRAFT = new State(Value.DRAFT, "draft");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case LIVE: {
                    return visitor.visitLive();
                }
                case DRAFT: {
                    return visitor.visitDraft();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "live": {
                    return LIVE;
                }
                case "draft": {
                    return DRAFT;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitDraft();

            public T visitLive();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            DRAFT,
            LIVE,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> workspaceId = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Optional<Integer> senderId = Optional.empty();
        private Optional<State> state = Optional.empty();
        private Optional<List<NewsfeedAssignment>> newsfeedAssignments = Optional.empty();
        private Optional<List<Optional<String>>> labels = Optional.empty();
        private Optional<String> coverImageUrl = Optional.empty();
        private Optional<List<Optional<String>>> reactions = Optional.empty();
        private Optional<Boolean> deliverSilently = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(NewsItem other) {
            this.type(other.getType());
            this.id(other.getId());
            this.workspaceId(other.getWorkspaceId());
            this.title(other.getTitle());
            this.body(other.getBody());
            this.senderId(other.getSenderId());
            this.state(other.getState());
            this.newsfeedAssignments(other.getNewsfeedAssignments());
            this.labels(other.getLabels());
            this.coverImageUrl(other.getCoverImageUrl());
            this.reactions(other.getReactions());
            this.deliverSilently(other.getDeliverSilently());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="workspace_id", nulls=Nulls.SKIP)
        public Builder workspaceId(Optional<String> workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = Optional.ofNullable(workspaceId);
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @JsonSetter(value="sender_id", nulls=Nulls.SKIP)
        public Builder senderId(Optional<Integer> senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder senderId(Integer senderId) {
            this.senderId = Optional.ofNullable(senderId);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<State> state) {
            this.state = state;
            return this;
        }

        public Builder state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="newsfeed_assignments", nulls=Nulls.SKIP)
        public Builder newsfeedAssignments(Optional<List<NewsfeedAssignment>> newsfeedAssignments) {
            this.newsfeedAssignments = newsfeedAssignments;
            return this;
        }

        public Builder newsfeedAssignments(List<NewsfeedAssignment> newsfeedAssignments) {
            this.newsfeedAssignments = Optional.ofNullable(newsfeedAssignments);
            return this;
        }

        @JsonSetter(value="labels", nulls=Nulls.SKIP)
        public Builder labels(Optional<List<Optional<String>>> labels) {
            this.labels = labels;
            return this;
        }

        public Builder labels(List<Optional<String>> labels) {
            this.labels = Optional.ofNullable(labels);
            return this;
        }

        @JsonSetter(value="cover_image_url", nulls=Nulls.SKIP)
        public Builder coverImageUrl(Optional<String> coverImageUrl) {
            this.coverImageUrl = coverImageUrl;
            return this;
        }

        public Builder coverImageUrl(String coverImageUrl) {
            this.coverImageUrl = Optional.ofNullable(coverImageUrl);
            return this;
        }

        @JsonSetter(value="reactions", nulls=Nulls.SKIP)
        public Builder reactions(Optional<List<Optional<String>>> reactions) {
            this.reactions = reactions;
            return this;
        }

        public Builder reactions(List<Optional<String>> reactions) {
            this.reactions = Optional.ofNullable(reactions);
            return this;
        }

        @JsonSetter(value="deliver_silently", nulls=Nulls.SKIP)
        public Builder deliverSilently(Optional<Boolean> deliverSilently) {
            this.deliverSilently = deliverSilently;
            return this;
        }

        public Builder deliverSilently(Boolean deliverSilently) {
            this.deliverSilently = Optional.ofNullable(deliverSilently);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        public NewsItem build() {
            return new NewsItem(this.type, this.id, this.workspaceId, this.title, this.body, this.senderId, this.state, this.newsfeedAssignments, this.labels, this.coverImageUrl, this.reactions, this.deliverSilently, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }
}

